/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import dev.sapphic.armorsoundtweak.ArmorSoundTweak;
import dev.sapphic.armorsoundtweak.EquipmentTicker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;

final class CuriosTicker
extends EquipmentTicker {
    CuriosTicker() {
    }

    static void register() {
        MinecraftForge.EVENT_BUS.addListener((Consumer)new CuriosTicker());
    }

    static void sendIdeImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().build());
    }

    private static IItemHandler getEquippedCurios(PlayerEntity player) {
        return (IItemHandler)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).orElse((Object)((IItemHandlerModifiable)EmptyHandler.INSTANCE));
    }

    @Override
    protected List<Item> getEquipment(PlayerEntity player) {
        IItemHandler handler = CuriosTicker.getEquippedCurios(player);
        ArrayList<Item> curios = new ArrayList<Item>(handler.getSlots());
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            curios.add(handler.getStackInSlot(slot).func_77973_b());
        }
        return curios;
    }

    @Override
    protected void playEquipSound(PlayerEntity player, Item item) {
        if (!ArmorSoundTweak.config().allowsCurios()) {
            return;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ICurio.SoundInfo sound = CuriosApi.getCuriosHelper().getCurio(new ItemStack((IItemProvider)item)).map(o -> o.getEquipSound(new SlotContext("", (LivingEntity)player))).orElse(null);
        if (sound != null) {
            player.func_213823_a(sound.getSoundEvent(), SoundCategory.NEUTRAL, sound.getVolume(), sound.getPitch());
        } else {
            player.func_213823_a(SoundEvents.field_187719_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }
}

