/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import com.google.common.base.Suppliers;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public final class EquipmentConfig {
    private final Slots slots;
    private final Sounds sounds;

    private EquipmentConfig(ForgeConfigSpec.Builder builder) {
        this.slots = new Slots(builder);
        builder.comment("The types of equip sounds to be played for equipment").push("sounds");
        this.sounds = new Sounds(builder);
        builder.pop();
    }

    static Supplier<EquipmentConfig> lazy() {
        return Suppliers.memoize(() -> {
            ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
            EquipmentConfig config = new EquipmentConfig(configBuilder);
            ModLoadingContext context = ModLoadingContext.get();
            context.registerConfig(ModConfig.Type.CLIENT, configBuilder.build(), "armorsoundtweak.toml");
            if (ModList.get().isLoaded("cloth-config")) {
                context.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> new ConfigGuiFactory(config));
            }
            return config;
        });
    }

    public boolean allowsArmor() {
        return (Boolean)this.slots.armor.get();
    }

    public boolean allowsCurios() {
        return (Boolean)this.slots.curios.get();
    }

    public Sounds sounds() {
        return this.sounds;
    }

    public static final class Sounds {
        private final ForgeConfigSpec.BooleanValue armor;
        private final ForgeConfigSpec.BooleanValue elytra;
        private final ForgeConfigSpec.BooleanValue skulls;
        private final ForgeConfigSpec.BooleanValue pumpkins;
        private final ForgeConfigSpec.BooleanValue anything;

        Sounds(ForgeConfigSpec.Builder builder) {
            this.armor = builder.define("armor", true);
            this.elytra = builder.define("elytra", true);
            this.skulls = builder.define("skulls", false);
            this.pumpkins = builder.define("pumpkins", false);
            this.anything = builder.define("anything", false);
        }

        public boolean hasArmor() {
            return (Boolean)this.armor.get();
        }

        public boolean hasElytra() {
            return (Boolean)this.elytra.get();
        }

        public boolean hasSkulls() {
            return (Boolean)this.skulls.get();
        }

        public boolean hasPumpkins() {
            return (Boolean)this.pumpkins.get();
        }

        public boolean hasAnything() {
            return (Boolean)this.anything.get();
        }
    }

    public static final class Slots {
        private final ForgeConfigSpec.BooleanValue armor;
        private final ForgeConfigSpec.BooleanValue curios;

        Slots(ForgeConfigSpec.Builder builder) {
            this.armor = builder.define("armor", true);
            this.curios = builder.define("curios", true);
        }
    }

    private static final class ConfigGuiFactory
    implements BiFunction<Minecraft, Screen, Screen> {
        private final EquipmentConfig config;

        private ConfigGuiFactory(EquipmentConfig config) {
            this.config = config;
        }

        private static ConfigCategory category(ConfigBuilder config, String name) {
            return config.getOrCreateCategory((ITextComponent)new TranslationTextComponent("armorsoundtweak.config." + name));
        }

        private static BooleanListEntry bool(ConfigEntryBuilder builder, String name, ForgeConfigSpec.BooleanValue value, boolean defaultValue) {
            return builder.startBooleanToggle((ITextComponent)new TranslationTextComponent("armorsoundtweak.config." + name), ((Boolean)value.get()).booleanValue()).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0)).setDefaultValue(defaultValue).build();
        }

        @Override
        public Screen apply(Minecraft minecraft, Screen screen) {
            ConfigBuilder config = ConfigBuilder.create().setTitle((ITextComponent)new TranslationTextComponent("armorsoundtweak.config"));
            ConfigEntryBuilder entries = config.entryBuilder();
            Slots slots = this.config.slots;
            ConfigGuiFactory.category(config, "slots").addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "slots.curios", slots.curios, true)).addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "slots.armor", slots.armor, true));
            Sounds sounds = this.config.sounds;
            ConfigGuiFactory.category(config, "sounds").addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "sounds.armor", sounds.armor, true)).addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "sounds.elytra", sounds.elytra, true)).addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "sounds.skulls", sounds.skulls, false)).addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "sounds.pumpkins", sounds.pumpkins, false)).addEntry((AbstractConfigListEntry)ConfigGuiFactory.bool(entries, "sounds.anything", sounds.anything, false));
            return config.build();
        }
    }
}

