/*
 * Decompiled with CFR 0.152.
 */
package com.emonadeo.autorun;

import com.emonadeo.autorun.MovementDirection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.client.keybinding.KeyBindingRegistry;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class AutoRun
implements ClientModInitializer {
    public static final String MODID = "autorun";
    public static final File CFG_FILE = new File(FabricLoader.getInstance().getConfigDirectory(), "autorun.properties");
    private static FabricKeyBinding keyBinding;
    private static Set<MovementDirection> toggled;
    private static long timeActivated;
    private static int delayBuffer;

    public void onInitializeClient() {
        toggled = new HashSet<MovementDirection>();
        timeActivated = -1L;
        delayBuffer = 20;
        keyBinding = FabricKeyBinding.Builder.create((class_2960)new class_2960(MODID, "toggle"), (class_3675.class_307)class_3675.class_307.field_1668, (int)80, (String)"key.categories.movement").build();
        AutoRun.loadConfig(CFG_FILE);
        KeyBindingRegistry.INSTANCE.register(keyBinding);
        ClientTickCallback.EVENT.register(client -> {
            if (client.field_1687 != null && keyBinding.method_1436()) {
                boolean activating = toggled.isEmpty();
                if (!activating) {
                    toggled.clear();
                } else {
                    Set pressedDirections = Arrays.stream(MovementDirection.values()).filter(dir -> dir.getKeyBinding(client).method_1434()).collect(Collectors.toSet());
                    if (!pressedDirections.isEmpty()) {
                        toggled.addAll(pressedDirections);
                    } else {
                        toggled.add(MovementDirection.FORWARD);
                    }
                    timeActivated = client.field_1687.method_8510();
                }
            }
            if (timeActivated != -1L && client.field_1687 != null && client.field_1687.method_8510() - timeActivated >= (long)delayBuffer) {
                block0: for (MovementDirection dir2 : toggled) {
                    for (class_304 terminator : dir2.getTerminators(client)) {
                        if (!terminator.method_1434()) continue;
                        toggled.clear();
                        timeActivated = -1L;
                        break block0;
                    }
                }
            }
        });
    }

    public static void loadConfig(File file) {
        try {
            Properties cfg = new Properties();
            if (!file.exists()) {
                AutoRun.saveConfig(file);
            }
            cfg.load(new FileInputStream(file));
            delayBuffer = Integer.parseInt(cfg.getProperty("delayBuffer"));
        }
        catch (IOException e) {
            e.printStackTrace();
            delayBuffer = 20;
        }
    }

    public static void saveConfig(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            fos.write(("delayBuffer=" + delayBuffer).getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set<MovementDirection> getToggled() {
        return toggled;
    }

    public static int getDelayBuffer() {
        return delayBuffer;
    }

    public static void setDelayBuffer(int delayBuffer) {
        AutoRun.delayBuffer = delayBuffer;
    }
}

