/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.renderer.entity.model.CatTailModel;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;

public class CatTailElement
extends ModelElement {
    public int length;
    public int swing;

    public String[] getDescription() {
        return new String[]{"Takes away the stick tails of the current cats and gives them something nicer instead.", "Fully animated flowing tails that move while they stand or run, and even curl around their bodies when they sit."};
    }

    public void constructClient() {
        this.addLayerTransformer(layerRenderer -> layerRenderer instanceof CatCollarLayer, () -> new CatTailModel(0.01f));
    }

    @Override
    public void setupClientConfig(OptionsBuilder builder) {
        super.setupClientConfig(builder);
        builder.define("Max Length", 15).min((Number)1).max((Number)15).comment(new String[]{"Define the max length of the tail."}).sync(v -> {
            this.length = v;
        }).restart();
        builder.define("Tail Swing", 7).min((Number)1).max((Number)20).comment(new String[]{"Swing amount of the tail."}).sync(v -> {
            this.swing = v;
        });
    }

    @Override
    protected EntityModel<? extends LivingEntity> getEntityModel() {
        return new CatTailModel(0.0f);
    }
}

