/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.client.renderer.entity.layers.ILayerModelAccessor;
import fuzs.betteranimationscollection.mixin.client.accessor.LivingRendererAccessor;
import fuzs.puzzleslib.config.ConfigManager;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.side.IClientElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ModelElement
extends AbstractElement
implements IClientElement {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Map<EntityType<?>, ModelInfo> entityTypeToModelInfo = Maps.newHashMap();
    private final List<LayerTransformer<?>> layerTransformers = Lists.newArrayList();
    protected final List<ResourceLocation> defaultEntityBlacklist = Lists.newArrayList();
    private Set<EntityType<?>> blacklistedEntities = Sets.newHashSet();

    public final void setupClient2() {
        this.collectModels();
    }

    public final void loadClient() {
        this.applyModelAction(ModelInfo::switchModel, entityType -> !this.blacklistedEntities.contains(entityType));
    }

    public final void unloadClient() {
        this.applyModelAction(ModelInfo::resetModel, entityType -> true);
    }

    public void setupClientConfig(OptionsBuilder builder) {
        builder.define("Mob Blacklist", this.defaultEntityBlacklist.stream().map(ResourceLocation::toString).collect(Collectors.toList())).comment(new String[]{"Mob variants these model changes shouldn't be applied to.", EntryCollectionBuilder.CONFIG_STRING}).sync(v -> {
            this.blacklistedEntities = ConfigManager.deserializeToSet((List)v, (IForgeRegistry)ForgeRegistries.ENTITIES);
            if (this.isEnabled() && this.isTypeLoaded(ModConfig.Type.CLIENT)) {
                this.applyModelAction(ModelInfo::resetModel, entityType -> this.blacklistedEntities.contains(entityType));
                this.applyModelAction(ModelInfo::switchModel, entityType -> !this.blacklistedEntities.contains(entityType));
            }
        });
    }

    protected abstract EntityModel<? extends LivingEntity> getEntityModel();

    protected final void addLayerTransformer(Predicate<LayerRenderer<?, ?>> filter, Supplier<? extends EntityModel<? extends Entity>> model) {
        this.layerTransformers.add(new LayerTransformer<EntityModel<? extends Entity>>(filter, model));
    }

    private void collectModels() {
        this.mc.func_175598_ae().field_78729_o.forEach((entityType, renderer) -> {
            if (renderer instanceof LivingRenderer) {
                LivingRenderer livingRenderer = (LivingRenderer)renderer;
                EntityModel<? extends LivingEntity> entityModel = this.getEntityModel();
                if (livingRenderer.func_217764_d().getClass().equals(entityModel.getClass().getSuperclass())) {
                    this.entityTypeToModelInfo.put((EntityType<?>)entityType, new ModelInfo((LivingRenderer<? extends LivingEntity, EntityModel<? extends LivingEntity>>)livingRenderer, (EntityModel<? extends LivingEntity>)livingRenderer.func_217764_d(), entityModel, this.layerTransformers.size()));
                }
            }
        });
    }

    private void applyModelAction(Consumer<ModelInfo> action, Predicate<EntityType<?>> filter) {
        for (Map.Entry<EntityType<?>, ModelInfo> entry : this.entityTypeToModelInfo.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            action.accept(entry.getValue());
        }
    }

    @FunctionalInterface
    private static interface LayerTransformation<T> {
        public T apply(LayerTransformer<?> var1, LayerRenderer<?, ?> var2, Integer var3);
    }

    private class ModelInfo {
        public final LivingRenderer<? extends LivingEntity, EntityModel<? extends LivingEntity>> livingRenderer;
        public final EntityModel<? extends LivingEntity> origModel;
        public final EntityModel<? extends LivingEntity> animatedModel;
        private final Object[] origLayerModels;
        private boolean isModelSwitched;

        public ModelInfo(LivingRenderer<? extends LivingEntity, EntityModel<? extends LivingEntity>> livingRenderer, EntityModel<? extends LivingEntity> origModel, EntityModel<? extends LivingEntity> animatedModel, int layerModelCapacity) {
            this.livingRenderer = livingRenderer;
            this.origModel = origModel;
            this.animatedModel = animatedModel;
            this.origLayerModels = new Object[layerModelCapacity];
        }

        public void switchModel() {
            if (!this.isModelSwitched) {
                this.isModelSwitched = true;
                this.setRendererModel(this.animatedModel);
                BetterAnimationsCollection.LOGGER.info("Replaced {} with {} for {}", (Object)this.origModel.getClass().getSimpleName(), (Object)this.animatedModel.getClass().getSimpleName(), (Object)this.livingRenderer.getClass().getSimpleName());
                this.switchLayers();
            }
        }

        public void resetModel() {
            if (this.isModelSwitched) {
                this.isModelSwitched = false;
                this.setRendererModel(this.origModel);
                BetterAnimationsCollection.LOGGER.info("Restored {} for {}", (Object)this.origModel.getClass().getSimpleName(), (Object)this.livingRenderer.getClass().getSimpleName());
                this.resetLayers();
            }
        }

        private void setRendererModel(EntityModel<? extends LivingEntity> model) {
            ((LivingRendererAccessor)this.livingRenderer).setModel(model);
        }

        private void switchLayers() {
            this.transformLayers((layerTransformer, layerRenderer, index) -> layerTransformer.applyTransform(layerRenderer), (result, index) -> {
                if (result != null) {
                    this.origLayerModels[index.intValue()] = result;
                    return true;
                }
                return false;
            });
        }

        private void resetLayers() {
            this.transformLayers((layerTransformer, layerRenderer, index) -> layerTransformer.applyRestore(layerRenderer, (EntityModel<Entity>)((EntityModel)this.origLayerModels[index])), (result, index) -> result);
        }

        private <T> void transformLayers(LayerTransformation<T> applyTransformer, BiPredicate<T, Integer> resultConverter) {
            if (ModelElement.this.layerTransformers.isEmpty()) {
                return;
            }
            for (LayerRenderer layerRenderer : ((LivingRendererAccessor)this.livingRenderer).getLayers()) {
                LayerTransformer layerTransformer;
                T result;
                if (!(layerRenderer instanceof ILayerModelAccessor)) continue;
                List transformers = ModelElement.this.layerTransformers;
                int transformersSize = transformers.size();
                for (int i = 0; i < transformersSize && !resultConverter.test(result = applyTransformer.apply(layerTransformer = (LayerTransformer)transformers.get(i), layerRenderer, i), i); ++i) {
                }
            }
        }
    }

    private static class LayerTransformer<M extends EntityModel<? extends Entity>> {
        private final Predicate<LayerRenderer<?, ?>> filter;
        private final Supplier<M> model;

        public LayerTransformer(Predicate<LayerRenderer<?, ?>> filter, Supplier<M> model) {
            this.filter = filter;
            this.model = model;
        }

        public EntityModel<? extends Entity> applyTransform(LayerRenderer<?, ?> layerRenderer) {
            if (this.filter.test(layerRenderer)) {
                ILayerModelAccessor modelAccessor = (ILayerModelAccessor)layerRenderer;
                Object origModel = modelAccessor.getModel();
                modelAccessor.setModel((EntityModel)this.model.get());
                BetterAnimationsCollection.LOGGER.info("Replaced layer model in {}", (Object)layerRenderer.getClass().getSimpleName());
                return origModel;
            }
            return null;
        }

        public boolean applyRestore(LayerRenderer<?, ?> layerRenderer, EntityModel<? extends Entity> origModel) {
            if (this.filter.test(layerRenderer) && origModel != null) {
                ILayerModelAccessor modelAccessor = (ILayerModelAccessor)layerRenderer;
                modelAccessor.setModel(origModel);
                BetterAnimationsCollection.LOGGER.info("Restored layer model in {}", (Object)layerRenderer.getClass().getSimpleName());
                return true;
            }
            return false;
        }
    }
}

