/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.side.IClientElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingEvent;

public class SoundDetectionElement
extends AbstractElement
implements IClientElement {
    private static final int MAX_SOUND_ANIMATION_TIME = 20;
    private static final Map<ResourceLocation, Class<? extends MobEntity>> AMBIENT_SOUNDS = Maps.newHashMap();
    private static final Set<Class<? extends MobEntity>> ATTACKABLE_ENTITIES = Sets.newHashSet();
    private final SoundDetectionListener soundListener = new SoundDetectionListener();
    private double soundRange;

    public String[] getDescription() {
        return new String[]{"This is required for sound related model animations."};
    }

    protected boolean isPersistent() {
        return true;
    }

    public void constructClient() {
        this.addListener(this::onLivingUpdate);
    }

    public void loadClient() {
        this.soundListener.load();
    }

    public void unloadClient() {
        this.soundListener.unload();
    }

    public void setupClientConfig(OptionsBuilder builder) {
        builder.define("Sound Detection Range", 1.5).min((Number)0.5).max((Number)8.0).comment(new String[]{"Block range for sound detection system to look for a mob that made a certain sound on the server, so the client may play an animation."}).sync(v -> {
            this.soundRange = v;
        });
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity entity = evt.getEntityLiving();
        if (!entity.field_70170_p.func_201670_d() || !(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        Stream.concat(AMBIENT_SOUNDS.values().stream(), ATTACKABLE_ENTITIES.stream()).forEach(clazz -> {
            if (clazz.isAssignableFrom(entity.getClass()) && mobEntity.field_70757_a >= 0) {
                mobEntity.field_70757_a = -mobEntity.func_70627_aG() + 20;
            }
        });
        for (Class<? extends MobEntity> clazz2 : ATTACKABLE_ENTITIES) {
            if (!clazz2.isAssignableFrom(entity.getClass()) || mobEntity.field_70738_aO <= 0 || mobEntity.field_70737_aN != mobEntity.field_70738_aO) continue;
            mobEntity.field_70757_a = -mobEntity.func_70627_aG();
        }
    }

    public static void addAmbientSounds(Class<? extends MobEntity> entityClazz, Collection<SoundEvent> soundEvents) {
        for (SoundEvent soundEvent : soundEvents) {
            AMBIENT_SOUNDS.put(soundEvent.func_187503_a(), entityClazz);
        }
    }

    public static void removeAmbientSounds(Collection<SoundEvent> soundEvents) {
        for (SoundEvent soundEvent : soundEvents) {
            AMBIENT_SOUNDS.remove(soundEvent.func_187503_a());
        }
    }

    public static void addAttackableEntity(Class<? extends MobEntity> entityClazz) {
        ATTACKABLE_ENTITIES.add(entityClazz);
    }

    private class SoundDetectionListener
    implements ISoundEventListener {
        private final Minecraft mc = Minecraft.func_71410_x();
        private boolean isLoaded;

        private SoundDetectionListener() {
        }

        public void load() {
            if (!this.isLoaded) {
                this.isLoaded = true;
                this.mc.func_147118_V().func_184402_a((ISoundEventListener)this);
            }
        }

        public void unload() {
            if (this.isLoaded) {
                this.isLoaded = false;
                this.mc.func_147118_V().func_184400_b((ISoundEventListener)this);
            }
        }

        public void func_184067_a(ISound soundIn, SoundEventAccessor accessor) {
            Class entityClazz = (Class)AMBIENT_SOUNDS.get(soundIn.func_147650_b());
            if (entityClazz != null) {
                Vector3d center = new Vector3d(soundIn.func_147649_g() + 0.0625, soundIn.func_147654_h() + 0.0625, soundIn.func_147651_i() + 0.0625);
                AxisAlignedBB axisAlignedBB = new AxisAlignedBB(center, center).func_186662_g(SoundDetectionElement.this.soundRange + 0.0625);
                assert (this.mc.field_71441_e != null);
                List entities = this.mc.field_71441_e.func_217357_a(entityClazz, axisAlignedBB);
                entities.stream().min((o1, o2) -> (int)Math.signum(o1.func_213303_ch().func_72438_d(center) - o2.func_213303_ch().func_72438_d(center))).ifPresent(entity -> {
                    entity.field_70757_a = -entity.func_70627_aG();
                });
            }
        }
    }
}

