/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.client.element.BuckaChickenElement;
import fuzs.betteranimationscollection.mixin.client.accessor.ChickenModelAccessor;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuckaChickenModel<T extends Entity>
extends ChickenModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer body;
    private final ModelRenderer leg0;
    private final ModelRenderer leg1;
    private final ModelRenderer wing0;
    private final ModelRenderer wing1;
    private final ModelRenderer redThing;
    private final ModelRenderer billBottom;

    public BuckaChickenModel() {
        ChickenModelAccessor modelAccessor = (ChickenModelAccessor)((Object)this);
        this.head = modelAccessor.getHead();
        this.body = modelAccessor.getBody();
        this.leg0 = modelAccessor.getLeg0();
        this.leg1 = modelAccessor.getLeg1();
        ModelRenderer billTop = new ModelRenderer((Model)this, 14, 0);
        billTop.func_228301_a_(-2.0f, -4.0f, -4.0f, 4.0f, 1.0f, 2.0f, 0.0f);
        this.head.func_78792_a(billTop);
        this.billBottom = new ModelRenderer((Model)this, 14, 1);
        this.billBottom.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 2.0f, 0.0f);
        this.billBottom.func_78793_a(0.0f, -3.0f, -2.0f);
        billTop.func_78792_a(this.billBottom);
        this.redThing = new ModelRenderer((Model)this, 14, 4);
        this.redThing.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.redThing.func_78793_a(0.0f, 1.0f, 0.0f);
        modelAccessor.setRedThing(this.redThing);
        this.billBottom.func_78792_a(this.redThing);
        this.wing0 = new ModelRenderer((Model)this, 24, 13);
        this.wing0.func_228300_a_(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f);
        this.wing0.func_78793_a(-3.0f, 13.0f, 0.0f);
        modelAccessor.setWing0(this.wing0);
        this.wing1 = new ModelRenderer((Model)this, 24, 13);
        this.wing1.func_228300_a_(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f);
        this.wing1.func_78793_a(3.0f, 13.0f, 0.0f);
        modelAccessor.setWing1(this.wing1);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.body.field_78795_f = 1.5707964f;
        this.leg0.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        BuckaChickenElement element = (BuckaChickenElement)BetterAnimationsCollection.BUCKA_CHICKEN;
        if (ageInTicks == 0.0f && element.moveWings) {
            float wingSwingAmount = limbSwingAmount * (float)element.wingSpeed * 0.1f;
            this.wing0.field_78808_h = MathHelper.func_76126_a((float)limbSwing) * wingSwingAmount + wingSwingAmount;
            this.wing1.field_78808_h = -(MathHelper.func_76126_a((float)limbSwing) * wingSwingAmount + wingSwingAmount);
        } else {
            this.wing0.field_78808_h = ageInTicks;
            this.wing1.field_78808_h = -ageInTicks;
        }
        if (element.moveHead) {
            this.head.field_78798_e = -4.0f + MathHelper.func_76134_b((float)limbSwing) * (float)element.headSpeed * 0.5f * limbSwingAmount;
        }
        if (element.moveChin) {
            this.redThing.field_78795_f = MathHelper.func_76126_a((float)limbSwing) * (float)element.chinSpeed * 0.1f * limbSwingAmount;
            this.redThing.field_78795_f -= this.billBottom.field_78795_f;
        }
    }

    public void func_212843_a_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (entitylivingbaseIn instanceof MobEntity) {
            MobEntity entitylivingIn = (MobEntity)entitylivingbaseIn;
            int soundTime = entitylivingIn.field_70757_a + entitylivingIn.func_70627_aG();
            if (0 < soundTime && soundTime < 8) {
                float rotation = Math.abs(MathHelper.func_76126_a((float)((float)soundTime * (float)Math.PI / 5.0f)));
                this.billBottom.field_78795_f = rotation * 0.75f;
            } else {
                this.billBottom.field_78795_f = 0.0f;
            }
        }
    }
}

