/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.client.element.OcelotTailElement;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class OcelotTailModel<T extends Entity>
extends OcelotModel<T> {
    private final ModelRenderer tail = OcelotTailModel.getTail((Model)this, 0.0f);
    private final ModelRenderer[] tailParts;

    public OcelotTailModel() {
        super(0.0f);
        OcelotTailElement element = (OcelotTailElement)BetterAnimationsCollection.FLOWY_OCELOT_TAIL;
        this.tailParts = OcelotTailModel.getTailParts((Model)this, element.length, 0.0f);
        this.tail.func_78792_a(this.tailParts[0]);
    }

    public static ModelRenderer getTail(Model model, float scale) {
        ModelRenderer tail = new ModelRenderer(model, 0, 15);
        tail.func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, scale);
        tail.field_78795_f = 0.9f;
        tail.func_78793_a(0.0f, 15.0f, 8.0f);
        return tail;
    }

    public static ModelRenderer[] getTailParts(Model model, int length, float scale) {
        ModelRenderer[] tailParts = new ModelRenderer[length];
        for (int i = 0; i < tailParts.length; ++i) {
            if (i < tailParts.length / 2) {
                tailParts[i] = new ModelRenderer(model, 0, 16 + i);
                tailParts[i].func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, scale);
                tailParts[i].func_78793_a(0.0f, 1.0f, 0.0f);
                if (i <= 0) continue;
                tailParts[i - 1].func_78792_a(tailParts[i]);
                continue;
            }
            tailParts[i] = new ModelRenderer(model, 4, 8 + i);
            tailParts[i].func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, scale);
            tailParts[i].func_78793_a(0.0f, 1.0f, 0.0f);
            tailParts[i - 1].func_78792_a(tailParts[i]);
        }
        return tailParts;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78162_h, (Object)this.field_78161_a, (Object)this.field_78159_b, (Object)this.field_78160_c, (Object)this.field_78157_d, (Object)this.tail);
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tail.field_78797_d = this.field_78158_e.field_78797_d;
        this.tail.field_78798_e = this.field_78158_e.field_78798_e;
        this.tail.field_78795_f = this.field_78158_e.field_78795_f;
        OcelotTailElement element = (OcelotTailElement)BetterAnimationsCollection.FLOWY_OCELOT_TAIL;
        OcelotTailModel.setTailAnim(this.tail, this.tailParts, limbSwing, limbSwingAmount, ageInTicks, element.swing);
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public static void setTailAnim(ModelRenderer tail, ModelRenderer[] tailParts, float limbSwing, float limbSwingAmount, float ageInTicks, int swing) {
        float magnitude = (0.5f + limbSwingAmount) * 0.125f;
        float amplitude = limbSwing * 0.6662f + ageInTicks / 4.66f * 0.6662f;
        tail.field_78795_f += MathHelper.func_76126_a((float)amplitude) * magnitude;
        for (int i = 0; i < tailParts.length; ++i) {
            tailParts[i].field_78808_h = 0.0f;
            tailParts[i].field_78795_f = 0.05f;
            tailParts[i].field_78795_f += MathHelper.func_76126_a((float)(amplitude - (float)(i + 1) * (float)swing * 0.05f)) * magnitude;
        }
    }
}

