/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.betteranimationscollection2.feature;

import com.fuzs.betteranimationscollection2.BetterAnimationsCollection2;
import com.fuzs.betteranimationscollection2.handler.CustomRenderingHandler;
import com.fuzs.betteranimationscollection2.helper.ConfigHelper;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public abstract class Feature<T extends Entity> {
    private final Class<T> entityClazz;
    private final IRenderFactory<? super T> renderFactory;
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.BooleanValue forced;
    private ForgeConfigSpec.BooleanValue compatibility;

    public Feature(Class<T> clazz, IRenderFactory<? super T> factory) {
        this.entityClazz = clazz;
        this.renderFactory = factory;
    }

    public void register() {
        if (this.isEnabled()) {
            if (ConfigHelper.getConfigBoolean((ForgeConfigSpec.ConfigValue<Boolean>)this.compatibility)) {
                BetterAnimationsCollection2.LOGGER.info("Registering \"" + this.getName() + "\" via custom method");
                CustomRenderingHandler.registerEntityRenderingHandler(this.entityClazz, ((IEntityRenderer)this.renderFactory.createRenderFor(Minecraft.func_71410_x().func_175598_ae())).func_217764_d());
            } else {
                BetterAnimationsCollection2.LOGGER.info("Registering \"" + this.getName() + "\" via default method");
                RenderingRegistry.registerEntityRenderingHandler(this.entityClazz, this.renderFactory);
            }
        }
    }

    private boolean isEnabled() {
        return (Boolean)this.enabled.get() != false && (ConfigHelper.getConfigBoolean((ForgeConfigSpec.ConfigValue<Boolean>)this.forced) || Arrays.stream(this.incompatibleMods()).noneMatch(it -> ModList.get().isLoaded(it)));
    }

    public abstract String getName();

    public abstract String getDescription();

    public boolean hasCompatibility() {
        return true;
    }

    protected String[] incompatibleMods() {
        return new String[0];
    }

    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Is this feature enabled.").define("enabled", true);
        String[] incompatible = this.incompatibleMods();
        if (incompatible.length > 0) {
            this.forced = builder.comment("Enable even if incompatible mods are loaded. Is incompatible with: " + ConfigHelper.arrayToCustomString(incompatible)).define("forced", false);
        }
        if (this.hasCompatibility()) {
            this.compatibility = builder.comment("Apply model in a more mod compatible way. Only enable when necessary").define("compatibility", false);
        }
    }
}

