/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.betteranimationscollection2.handler;

import com.fuzs.betteranimationscollection2.handler.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundEventHandler
implements ISoundEventListener {
    private final Map<String, Class<?>> sounds = new HashMap<String, Class<?>>(){
        {
            this.put("entity.pig.ambient", PigEntity.class);
            this.put("entity.villager.ambient", VillagerEntity.class);
            this.put("entity.chicken.ambient", ChickenEntity.class);
            this.put("entity.snow_golem.shoot", SnowGolemEntity.class);
        }
    };
    private final List<Class<?>> hurts = new ArrayList<Class<?>>(){
        {
            this.add(VillagerEntity.class);
            this.add(IronGolemEntity.class);
        }
    };

    public SoundEventHandler() {
        Minecraft.func_71410_x().func_147118_V().func_184402_a((ISoundEventListener)this);
    }

    @SubscribeEvent
    public void updateEntity(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity entity = evt.getEntityLiving();
        boolean flag = this.hurts.stream().anyMatch(it -> it.isInstance(entity));
        if (entity.field_70170_p.field_72995_K && (flag || this.sounds.values().stream().anyMatch(it -> it.isInstance(entity)))) {
            MobEntity entityLiving = (MobEntity)entity;
            if (entityLiving.field_70757_a > -1) {
                entityLiving.field_70757_a = -entityLiving.func_70627_aG() + 20;
            }
            if (flag && entityLiving.field_70738_aO > 0 && entityLiving.field_70737_aN == entityLiving.field_70738_aO) {
                entityLiving.field_70757_a = -entityLiving.func_70627_aG();
            }
        }
    }

    public void func_184067_a(@Nonnull ISound soundIn, @Nonnull SoundEventAccessor accessor) {
        if (this.sounds.keySet().stream().anyMatch(it -> soundIn.func_147650_b().func_110623_a().equals(it))) {
            for (Entity entity : Minecraft.func_71410_x().field_71441_e.func_217416_b()) {
                if (!this.checkPos((float)entity.field_70165_t, soundIn.func_147649_g()) || !this.checkPos((float)entity.field_70163_u, soundIn.func_147654_h()) || !this.checkPos((float)entity.field_70161_v, soundIn.func_147651_i()) || !this.sounds.get(soundIn.func_147650_b().func_110623_a()).isInstance(entity)) continue;
                MobEntity entityLiving = (MobEntity)entity;
                entityLiving.field_70757_a = -entityLiving.func_70627_aG();
                break;
            }
        }
    }

    private boolean checkPos(float entityPos, float soundPos) {
        return (double)(entityPos = (float)((int)(entityPos * 8.0f)) / 8.0f) - (Double)ConfigHandler.soundRange.get() < (double)soundPos && (double)entityPos + (Double)ConfigHandler.soundRange.get() > (double)soundPos;
    }
}

