/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.betteranimationscollection2.renderer.model;

import com.fuzs.betteranimationscollection2.feature.FeatureCreeper;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WobblyCreeperModel<T extends Entity>
extends EntityModel<T> {
    private final RendererModel head = new RendererModel((Model)this, 0, 0);
    protected final RendererModel[] bodyParts;
    private final RendererModel body;
    protected final RendererModel leg1;
    protected final RendererModel leg2;
    protected final RendererModel leg3;
    protected final RendererModel leg4;

    public WobblyCreeperModel() {
        this(0.0f);
    }

    public WobblyCreeperModel(float scale) {
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, scale);
        this.head.func_78793_a(0.0f, 1.0f, 0.0f);
        this.body = new RendererModel((Model)this, 16, 27);
        this.body.func_78790_a(-4.0f, 11.0f, -2.0f, 8, 1, 4, scale);
        this.body.func_78793_a(0.0f, 6.0f, 0.0f);
        this.bodyParts = new RendererModel[11];
        for (int i = 0; i < 11; ++i) {
            this.bodyParts[i] = new RendererModel((Model)this, 16, 26 - i);
            this.bodyParts[i].func_78790_a(-4.0f, 1.0f, -2.0f, 8, 1, 4, scale);
            if (i == 0) {
                this.bodyParts[i].func_78793_a(0.0f, 9.0f, 0.0f);
                this.body.func_78792_a(this.bodyParts[i]);
                continue;
            }
            this.bodyParts[i].func_78793_a(0.0f, -1.0f, 0.0f);
            this.bodyParts[i - 1].func_78792_a(this.bodyParts[i]);
        }
        this.bodyParts[10].func_78792_a(this.head);
        this.leg1 = new RendererModel((Model)this, 0, 16);
        this.leg1.func_78790_a(-2.0f, 0.0f, 0.0f, 4, 6, 4, scale);
        this.leg1.func_78793_a(-2.0f, 18.0f, 2.0f);
        this.leg2 = new RendererModel((Model)this, 0, 16);
        this.leg2.func_78790_a(-2.0f, 0.0f, 0.0f, 4, 6, 4, scale);
        this.leg2.func_78793_a(2.0f, 18.0f, 2.0f);
        this.leg3 = new RendererModel((Model)this, 0, 16);
        this.leg3.func_78790_a(-2.0f, 0.0f, -4.0f, 4, 6, 4, scale);
        this.leg3.func_78793_a(-2.0f, 18.0f, -2.0f);
        this.leg4 = new RendererModel((Model)this, 0, 16);
        this.leg4.func_78790_a(-2.0f, 0.0f, -4.0f, 4, 6, 4, scale);
        this.leg4.func_78793_a(2.0f, 18.0f, -2.0f);
    }

    public void func_78088_a(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_212844_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.body.func_78785_a(scale);
        this.leg1.func_78785_a(scale);
        this.leg2.func_78785_a(scale);
        this.leg3.func_78785_a(scale);
        this.leg4.func_78785_a(scale);
    }

    public void func_212844_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float magnitude = this.getMagnitude(limbSwingAmount *= 3.5f);
        for (int i = 0; i < 11; ++i) {
            this.bodyParts[i].field_78808_h = 0.0f;
            this.bodyParts[i].field_78795_f = 0.0f;
            int mode = ((FeatureCreeper.CreeperMode)((Object)FeatureCreeper.mode.get())).ordinal();
            if (mode == 3) {
                this.rotate(magnitude, limbSwing, i, (int)Math.abs(entityIn.func_110124_au().getLeastSignificantBits() % 3L));
                continue;
            }
            this.rotate(magnitude, limbSwing, i, mode);
        }
    }

    private void rotate(float magnitude, float limbSwing, int i, int mode) {
        if (mode == 0) {
            this.bodyParts[i].field_78808_h = magnitude * MathHelper.func_76134_b((float)(limbSwing * 0.6662f));
        } else if (mode == 1) {
            this.bodyParts[i].field_78795_f = magnitude * MathHelper.func_76134_b((float)(limbSwing * 0.6662f));
        } else if (mode == 2) {
            this.bodyParts[i].field_78795_f = magnitude * MathHelper.func_76126_a((float)(limbSwing * 0.6662f));
            this.bodyParts[i].field_78808_h = magnitude * MathHelper.func_76134_b((float)(limbSwing * 0.6662f));
        }
    }

    private float getMagnitude(float limbSwingAmount) {
        float magnitude = limbSwingAmount < 0.0f ? 0.0f : (limbSwingAmount < 0.6f ? 0.125f * limbSwingAmount : 0.075f);
        return magnitude;
    }
}

