/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.betteranimationscollection2.renderer.model;

import com.fuzs.betteranimationscollection2.feature.FeatureWolf;
import com.fuzs.betteranimationscollection2.helper.ReflectionHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WolfTailModel<T extends WolfEntity>
extends WolfModel<T> {
    private final RendererModel head;
    private final RendererModel body;
    private final RendererModel leg1;
    private final RendererModel leg2;
    private final RendererModel leg3;
    private final RendererModel leg4;
    private final RendererModel tail;
    private final RendererModel mane;
    private final RendererModel[] tailParts = new RendererModel[7];

    public WolfTailModel() {
        this.tail = new RendererModel((Model)this, 9, 18);
        this.tail.func_78790_a(0.0f, 0.0f, -1.0f, 2, 1, 2, 0.0f);
        this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
        for (int i = 0; i < this.tailParts.length; ++i) {
            this.tailParts[i] = new RendererModel((Model)this, 9, Math.min(19 + i, 25));
            float fluffy = 0.0f;
            if (((Boolean)FeatureWolf.fluffy.get()).booleanValue()) {
                fluffy = i < 5 ? 0.1f + 0.1f * (float)i : (i == 5 ? 0.4f : 0.15f);
            }
            this.tailParts[i].func_78790_a(0.0f, 0.0f, -1.0f, 2, 1, 2, fluffy);
            this.tailParts[i].func_78793_a(0.0f, 1.0f + fluffy, 0.0f);
            if (i == 0) {
                this.tail.func_78792_a(this.tailParts[i]);
                continue;
            }
            this.tailParts[i - 1].func_78792_a(this.tailParts[i]);
        }
        this.head = (RendererModel)ReflectionHelper.getModelPart(this, "field_78185_a");
        this.body = (RendererModel)ReflectionHelper.getModelPart(this, "field_78183_b");
        this.leg1 = (RendererModel)ReflectionHelper.getModelPart(this, "field_78184_c");
        this.leg2 = (RendererModel)ReflectionHelper.getModelPart(this, "field_78181_d");
        this.leg3 = (RendererModel)ReflectionHelper.getModelPart(this, "field_78182_e");
        this.leg4 = (RendererModel)ReflectionHelper.getModelPart(this, "field_78179_f");
        this.mane = (RendererModel)ReflectionHelper.getModelPart(this, "field_78186_h");
        ReflectionHelper.setModelPart(this, this.tail, "field_78180_g");
    }

    public void func_78088_a(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_212844_a_((WolfEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.pushMatrix();
        if (((Boolean)FeatureWolf.lieDown.get()).booleanValue() && ((Boolean)FeatureWolf.rollOver.get()).booleanValue() && entityIn.func_70906_o() && entityIn.func_70922_bv()) {
            float f = entityIn.func_70917_k(1.0f) + entityIn.func_70923_f(1.0f, 0.0f);
            GlStateManager.translatef((float)0.0f, (float)1.25f, (float)0.0f);
            GlStateManager.rotatef((float)(f * 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0f, (float)-1.25f, (float)0.0f);
            this.leg1.field_78795_f += f * 1.5f;
            this.leg2.field_78795_f += f * 1.5f;
            this.leg3.field_78795_f += f * 1.5f;
            this.leg4.field_78795_f += f * 1.5f;
            this.leg1.field_78797_d -= f * 1.75f;
            this.leg2.field_78797_d -= f * 1.75f;
            this.leg3.field_78797_d -= f * 1.75f;
            this.leg4.field_78797_d -= f * 1.75f;
            this.head.field_78808_h = -f * 1.5f;
        }
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)(5.0f * scale), (float)(2.0f * scale));
            this.head.func_78791_b(scale);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.body.func_78785_a(scale);
            this.leg1.func_78785_a(scale);
            this.leg2.func_78785_a(scale);
            this.leg3.func_78785_a(scale);
            this.leg4.func_78785_a(scale);
            this.tail.func_78785_a(scale);
            this.mane.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            this.head.func_78791_b(scale);
            this.body.func_78785_a(scale);
            this.leg1.func_78785_a(scale);
            this.leg2.func_78785_a(scale);
            this.leg3.func_78785_a(scale);
            this.leg4.func_78785_a(scale);
            this.tail.func_78785_a(scale);
            this.mane.func_78785_a(scale);
        }
        GlStateManager.popMatrix();
    }

    public void func_212843_a_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.func_212843_a_(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        if (entitylivingbaseIn.func_70906_o()) {
            if (((Boolean)FeatureWolf.lieDown.get()).booleanValue()) {
                this.mane.func_78793_a(-1.0f, 17.5f, -3.0f);
                this.mane.field_78795_f = 1.5707964f;
                this.mane.field_78796_g = 0.0f;
                this.body.func_78793_a(0.0f, 17.5f, 0.0f);
                this.body.field_78795_f = 1.3463969f;
                this.tail.func_78793_a(-1.0f, 19.0f, 6.0f);
                this.leg1.func_78793_a(-2.5f, 22.0f, 5.25f);
                this.leg1.field_78795_f = 4.712389f;
                this.leg1.field_78796_g = 0.4f;
                this.leg2.func_78793_a(0.5f, 22.0f, 5.25f);
                this.leg2.field_78795_f = 4.712389f;
                this.leg2.field_78796_g = -0.4f;
                this.leg3.field_78795_f = 4.712389f;
                this.leg3.func_78793_a(-2.49f, 21.5f, -2.0f);
                this.leg3.field_78796_g = 0.15f;
                this.leg4.field_78795_f = 4.712389f;
                this.leg4.func_78793_a(0.51f, 21.5f, -2.0f);
                this.leg4.field_78796_g = -0.15f;
                this.head.field_78797_d = 17.0f;
            } else {
                this.mane.func_78793_a(-1.0f, 16.0f, -3.0f);
                this.mane.field_78795_f = 1.2566371f;
                this.mane.field_78796_g = 0.0f;
                this.tail.func_78793_a(-1.0f, 21.0f, 6.0f);
            }
        } else {
            this.mane.func_78793_a(-1.0f, 14.0f, -3.0f);
            this.mane.field_78795_f = this.body.field_78795_f;
            this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
            this.head.field_78797_d = 13.5f;
            this.leg4.field_78796_g = 0.0f;
            this.leg3.field_78796_g = 0.0f;
            this.leg2.field_78796_g = 0.0f;
            this.leg1.field_78796_g = 0.0f;
        }
        this.mane.field_78808_h = entitylivingbaseIn.func_70923_f(partialTickTime, -0.08f);
        this.tail.field_78808_h = entitylivingbaseIn.func_70923_f(partialTickTime, -0.2f);
        float progress = ((float)((WolfEntity)entitylivingbaseIn).field_70173_aa + partialTickTime) / 3.978873f;
        float magnitude = (0.5f + Math.max(limbSwingAmount, entitylivingbaseIn.func_70917_k(partialTickTime) * 1.5f)) * 0.25f;
        float amplitude = limbSwing * 0.6662f + progress * 0.6662f;
        if (!entitylivingbaseIn.func_70909_n()) {
            this.tail.field_78796_g = 0.0f;
            this.tail.field_78795_f += MathHelper.func_76126_a((float)amplitude) * magnitude;
            for (int i = 0; i < this.tailParts.length; ++i) {
                this.tailParts[i].field_78808_h = 0.0f;
                this.tailParts[i].field_78795_f = MathHelper.func_76126_a((float)(amplitude - (float)(i + 1) * (float)((Integer)FeatureWolf.swing.get()).intValue() * 0.15f)) * magnitude;
            }
        } else {
            this.tail.field_78796_g = MathHelper.func_76126_a((float)amplitude) * magnitude;
            for (int i = 0; i < this.tailParts.length; ++i) {
                this.tailParts[i].field_78795_f = 0.0f;
                this.tailParts[i].field_78808_h = MathHelper.func_76126_a((float)(amplitude - (float)(i + 1) * (float)((Integer)FeatureWolf.swing.get()).intValue() * 0.15f)) * magnitude;
            }
        }
    }
}

