/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.betteranimationscollection2.renderer.render;

import com.fuzs.betteranimationscollection2.renderer.layer.WolfTailCollarLayer;
import com.fuzs.betteranimationscollection2.renderer.model.WolfTailModel;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WolfTailRenderer
extends MobRenderer<WolfEntity, WolfTailModel<WolfEntity>> {
    private static final ResourceLocation WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation TAMED_WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation ANRGY_WOLF_TEXTURES = new ResourceLocation("textures/entity/wolf/wolf_angry.png");

    public WolfTailRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new WolfTailModel(), 0.5f);
        this.func_177094_a(new WolfTailCollarLayer((IEntityRenderer<WolfEntity, WolfTailModel<WolfEntity>>)this));
    }

    protected float handleRotationFloat(WolfEntity livingBase, float partialTicks) {
        return livingBase.func_70920_v();
    }

    public void doRender(WolfEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.func_70921_u()) {
            float f = entity.func_70013_c() * entity.func_70915_j(partialTicks);
            GlStateManager.color3f((float)f, (float)f, (float)f);
        }
        super.func_76986_a((MobEntity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(WolfEntity entity) {
        if (entity.func_70909_n()) {
            return TAMED_WOLF_TEXTURES;
        }
        return entity.func_70919_bu() ? ANRGY_WOLF_TEXTURES : WOLF_TEXTURES;
    }
}

