/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.enums;

import biomesoplenty.init.ModBiomes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraftforge.common.BiomeManager;

public enum BOPClimates {
    ICE_CAP(BiomeManager.BiomeType.ICY),
    TUNDRA(BiomeManager.BiomeType.ICY),
    WET_BOREAL(BiomeManager.BiomeType.COOL),
    DRY_BOREAL(BiomeManager.BiomeType.COOL),
    WET_TEMPERATE(BiomeManager.BiomeType.COOL),
    DRY_TEMPERATE(BiomeManager.BiomeType.WARM),
    COOL_TEMPERATE(BiomeManager.BiomeType.COOL),
    WARM_TEMPERATE(BiomeManager.BiomeType.WARM),
    SUBTROPICAL(BiomeManager.BiomeType.WARM),
    TROPICAL(BiomeManager.BiomeType.DESERT),
    MEDITERRANEAN(BiomeManager.BiomeType.WARM),
    SAVANNA(BiomeManager.BiomeType.DESERT),
    HOT_DESERT(BiomeManager.BiomeType.DESERT),
    WASTELAND(null),
    NETHER(null);

    public final BiomeManager.BiomeType biomeType;
    private int totalBiomesWeight;
    private int totalIslandBiomesWeight;
    private ArrayList<WeightedBiomeEntry> landBiomes = Lists.newArrayList();
    private ArrayList<WeightedBiomeEntry> islandBiomes = Lists.newArrayList();
    private static BOPClimates[] values;
    private static final BOPClimates[] climateMapping;

    private BOPClimates(BiomeManager.BiomeType biomeType) {
        this.biomeType = biomeType;
    }

    public BOPClimates addBiome(int weight, ResourceKey<Biome> biome) {
        return this.addBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addBiome(WeightedBiomeEntry biomeEntry) {
        this.totalBiomesWeight += biomeEntry.weight;
        this.landBiomes.add(biomeEntry);
        return this;
    }

    public BOPClimates addIslandBiome(int weight, ResourceKey<Biome> biome) {
        return this.addIslandBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addIslandBiome(WeightedBiomeEntry biomeEntry) {
        this.totalIslandBiomesWeight += biomeEntry.weight;
        this.islandBiomes.add(biomeEntry);
        return this;
    }

    public ResourceKey<Biome> getRandomBiome(Context context, ResourceKey<Biome> fallback) {
        WeightedBiomeEntry item;
        if (this.totalBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.m_5826_(this.totalBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.landBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public ResourceKey<Biome> getRandomIslandBiome(Context context, ResourceKey<Biome> fallback) {
        WeightedBiomeEntry item;
        if (this.totalIslandBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.m_5826_(this.totalIslandBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.islandBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public ResourceKey<Biome> getRandomOceanBiome(Context context, boolean deep) {
        return deep ? Biomes.f_48225_ : Biomes.f_48174_;
    }

    public ImmutableList<WeightedBiomeEntry> getLandBiomes() {
        return this.landBiomes.isEmpty() ? ImmutableList.of((Object)this.getDefaultWeightedBiomeEntry()) : ImmutableList.copyOf(this.landBiomes);
    }

    public ImmutableList<WeightedBiomeEntry> getIslandBiomes() {
        return this.islandBiomes.isEmpty() ? ImmutableList.of((Object)this.getDefaultWeightedBiomeEntry()) : ImmutableList.copyOf(this.islandBiomes);
    }

    private WeightedBiomeEntry getDefaultWeightedBiomeEntry() {
        return new WeightedBiomeEntry(100, (ResourceKey<Biome>)Biomes.f_48174_);
    }

    public static BOPClimates lookup(int i) {
        return values[i];
    }

    public static int[] getClimateMappingInts() {
        int[] out = new int[108];
        for (int i = 0; i < 108; ++i) {
            out[i] = climateMapping[i].ordinal();
        }
        return out;
    }

    public static ImmutableSet<ResourceKey<Biome>> getOverworldBiomes() {
        HashSet set = Sets.newHashSet();
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate == NETHER) continue;
            set.addAll(climate.getLandBiomes().stream().map(weightedBiomeEntry -> weightedBiomeEntry.biome).collect(Collectors.toSet()));
            set.addAll(climate.getIslandBiomes().stream().map(weightedBiomeEntry -> weightedBiomeEntry.biome).collect(Collectors.toSet()));
        }
        ModBiomes.subBiomes.values().forEach(weightedSubBiome -> set.add(weightedSubBiome.biome));
        return ImmutableSet.copyOf((Collection)set);
    }

    public static void printWeights() {
        for (BOPClimates climate : BOPClimates.values()) {
            for (WeightedBiomeEntry entry : climate.landBiomes) {
                System.out.println(climate.name() + " " + entry.biome.m_135782_() + " " + entry.weight);
            }
        }
    }

    static {
        values = BOPClimates.values();
        climateMapping = new BOPClimates[]{TUNDRA, TUNDRA, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, TUNDRA, TUNDRA, WET_BOREAL, WET_BOREAL, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, DRY_BOREAL, DRY_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, SUBTROPICAL, SUBTROPICAL, WET_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, DRY_TEMPERATE, SAVANNA, SAVANNA, SUBTROPICAL, SUBTROPICAL, SUBTROPICAL, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, SAVANNA, SAVANNA, SAVANNA, TROPICAL, TROPICAL, SUBTROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, SUBTROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, SAVANNA, HOT_DESERT, HOT_DESERT};
    }

    public static class WeightedBiomeEntry {
        public final int weight;
        public final ResourceKey<Biome> biome;

        public WeightedBiomeEntry(int weight, ResourceKey<Biome> biome) {
            this.weight = weight;
            this.biome = biome;
        }
    }
}

