/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeConfigData;
import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.biome.BiomeTemplate;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.util.config.JsonUtil;
import biomesoplenty.core.BiomesOPlenty;
import biomesoplenty.init.ModBiomes;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeRegistry {
    private static final String CONFIG_FILE_NAME = "biomes.json";
    private static Map<RegistrationType, List<DeferredRegistration>> deferrances = Maps.newHashMap();

    public static void deferStandardRegistration(BiomeTemplate biome, String name) {
        BiomeRegistry.defer(RegistrationType.STANDARD_BIOME, new StandardBiomeRegistrationData(biome, name));
    }

    public static void deferTechnicalBiomeRegistration(BiomeTemplate biome, String name) {
        BiomeRegistry.defer(RegistrationType.TECHNICAL_BIOME, new ToggleableStandardBiomeRegistrationData(biome, name, true));
    }

    public static void deferSubBiomeRegistration(ResourceKey<Biome> parent, ResourceKey<Biome> child, int weight, float rarity) {
        if (!BiomeUtil.exists(parent) || !BiomeUtil.exists(child)) {
            return;
        }
        BiomeRegistry.defer(RegistrationType.SUB_BIOME, new SubBiomeRegistrationData(parent, child, weight, rarity));
    }

    public static void deferIslandBiomeRegistration(ResourceKey<Biome> key, BOPClimates climate, int weight) {
        if (!BiomeUtil.exists(key)) {
            return;
        }
        BiomeRegistry.defer(RegistrationType.ISLAND_BIOME, new SingleClimateRegistrationData(key, climate, weight));
    }

    public static void deferVanillaBiomeRegistration(ResourceKey<Biome> key, BOPClimates climate, int weight) {
        if (!BiomeUtil.exists(key)) {
            return;
        }
        BiomeRegistry.defer(RegistrationType.VANILLA_BIOME, new SingleClimateRegistrationData(key, climate, weight));
    }

    public static void configureStandardBiomes() {
        List<DeferredRegistration> standardRegistrations = deferrances.get((Object)RegistrationType.STANDARD_BIOME);
        TreeMap defaultEntries = Maps.newTreeMap();
        HashMap regDataMap = Maps.newHashMap();
        for (DeferredRegistration registration : standardRegistrations) {
            StandardBiomeRegistrationData regData = (StandardBiomeRegistrationData)registration.regData;
            if (!regData.getMetadata().hasWeights()) continue;
            String biomeName = new ResourceLocation("biomesoplenty", regData.getName()).toString();
            Pair<BOPClimates, Integer> primaryWeight = regData.getPrimaryWeight();
            defaultEntries.put(biomeName, new BiomeConfigData.WeightedBiomeEntry((Integer)primaryWeight.getValue()));
            regDataMap.put(biomeName, (StandardBiomeRegistrationData)registration.regData);
        }
        BiomeConfigData defaultConfigData = new BiomeConfigData();
        defaultConfigData.standardBiomeWeights = defaultEntries;
        BiomeConfigData configData = BiomeRegistry.getConfigData(defaultConfigData);
        TreeMap revisedStandardBiomeWeights = Maps.newTreeMap((SortedMap)defaultEntries);
        for (Map.Entry<String, BiomeConfigData.WeightedBiomeEntry> biomeEntry : configData.standardBiomeWeights.entrySet()) {
            if (!revisedStandardBiomeWeights.containsKey(biomeEntry.getKey())) continue;
            revisedStandardBiomeWeights.put(biomeEntry.getKey(), biomeEntry.getValue());
        }
        configData.standardBiomeWeights = revisedStandardBiomeWeights;
        JsonUtil.writeFile(BiomeRegistry.getConfigFile(), configData);
        for (Map.Entry<String, BiomeConfigData.WeightedBiomeEntry> biomeEntry : configData.standardBiomeWeights.entrySet()) {
            String name = biomeEntry.getKey();
            BiomeConfigData.WeightedBiomeEntry weight = biomeEntry.getValue();
            if (!regDataMap.containsKey(name)) continue;
            StandardBiomeRegistrationData registrationData = (StandardBiomeRegistrationData)regDataMap.get(name);
            registrationData.setPrimaryWeight(weight.weight);
        }
    }

    public static void configureTechnicalBiomes() {
        List<DeferredRegistration> biomeRegistrations = deferrances.get((Object)RegistrationType.TECHNICAL_BIOME);
        TreeMap defaultBiomeEntries = Maps.newTreeMap();
        for (DeferredRegistration registration : biomeRegistrations) {
            ToggleableStandardBiomeRegistrationData regData = (ToggleableStandardBiomeRegistrationData)registration.regData;
            String biomeName = new ResourceLocation("biomesoplenty", regData.getName()).toString();
            defaultBiomeEntries.put(biomeName, new BiomeConfigData.ToggleableBiomeEntry(true));
        }
        BiomeConfigData defaultConfigData = new BiomeConfigData();
        defaultConfigData.technicalBiomeEntries = defaultBiomeEntries;
        BiomeConfigData configData = BiomeRegistry.getConfigData(defaultConfigData);
        TreeMap revisedBiomeEntries = Maps.newTreeMap((SortedMap)defaultBiomeEntries);
        for (Map.Entry<String, BiomeConfigData.ToggleableBiomeEntry> biomeEntry : configData.technicalBiomeEntries.entrySet()) {
            if (!revisedBiomeEntries.containsKey(biomeEntry.getKey())) continue;
            revisedBiomeEntries.put(biomeEntry.getKey(), biomeEntry.getValue());
        }
        configData.technicalBiomeEntries = revisedBiomeEntries;
        JsonUtil.writeFile(BiomeRegistry.getConfigFile(), configData);
        for (DeferredRegistration registration : biomeRegistrations) {
            ToggleableStandardBiomeRegistrationData regData = (ToggleableStandardBiomeRegistrationData)registration.regData;
            String biomeName = new ResourceLocation("biomesoplenty", regData.getName()).toString();
            if (!revisedBiomeEntries.containsKey(biomeName)) continue;
            BiomeConfigData.ToggleableBiomeEntry entry = (BiomeConfigData.ToggleableBiomeEntry)revisedBiomeEntries.get(biomeName);
            if (entry.enabled) continue;
            ((ToggleableStandardBiomeRegistrationData)registration.regData).setEnabled(false);
        }
    }

    public static void configureSubBiomes() {
        List<DeferredRegistration> subBiomeRegistrations = deferrances.get((Object)RegistrationType.SUB_BIOME);
        TreeMap defaultSubBiomeEntries = Maps.newTreeMap();
        HashMap regDataMap = Maps.newHashMap();
        for (DeferredRegistration registration : subBiomeRegistrations) {
            SubBiomeRegistrationData regData = (SubBiomeRegistrationData)registration.regData;
            String biomeName = ((SubBiomeRegistrationData)registration.regData).getChild().m_135782_().toString();
            defaultSubBiomeEntries.put(biomeName, new BiomeConfigData.SubBiomeEntry(regData.getWeight(), regData.getRarity()));
            regDataMap.put(biomeName, (SubBiomeRegistrationData)registration.regData);
        }
        BiomeConfigData defaultConfigData = new BiomeConfigData();
        defaultConfigData.subBiomeEntries = defaultSubBiomeEntries;
        BiomeConfigData configData = BiomeRegistry.getConfigData(defaultConfigData);
        TreeMap revisedSubBiomeEntries = Maps.newTreeMap((SortedMap)defaultSubBiomeEntries);
        for (Map.Entry<String, BiomeConfigData.SubBiomeEntry> biomeEntry : configData.subBiomeEntries.entrySet()) {
            if (!revisedSubBiomeEntries.containsKey(biomeEntry.getKey())) continue;
            revisedSubBiomeEntries.put(biomeEntry.getKey(), biomeEntry.getValue());
        }
        configData.subBiomeEntries = revisedSubBiomeEntries;
        JsonUtil.writeFile(BiomeRegistry.getConfigFile(), configData);
        for (Map.Entry<String, BiomeConfigData.SubBiomeEntry> biomeEntry : configData.subBiomeEntries.entrySet()) {
            String name = biomeEntry.getKey();
            BiomeConfigData.SubBiomeEntry subBiomeEntry = biomeEntry.getValue();
            if (!regDataMap.containsKey(name)) continue;
            SubBiomeRegistrationData registrationData = (SubBiomeRegistrationData)regDataMap.get(name);
            registrationData.setWeight(subBiomeEntry.weight);
            registrationData.setRarity(subBiomeEntry.rarity);
        }
    }

    public static void configureIslandBiomes() {
        List<DeferredRegistration> biomeRegistrations = deferrances.get((Object)RegistrationType.ISLAND_BIOME);
        TreeMap defaultBiomeEntries = Maps.newTreeMap();
        for (DeferredRegistration registration : biomeRegistrations) {
            SingleClimateRegistrationData regData = (SingleClimateRegistrationData)registration.regData;
            String biomeName = regData.getBiome().m_135782_().toString();
            defaultBiomeEntries.put(biomeName, new BiomeConfigData.ToggleableBiomeEntry(true));
        }
        BiomeConfigData defaultConfigData = new BiomeConfigData();
        defaultConfigData.islandBiomeEntries = defaultBiomeEntries;
        BiomeConfigData configData = BiomeRegistry.getConfigData(defaultConfigData);
        TreeMap revisedBiomeEntries = Maps.newTreeMap((SortedMap)defaultBiomeEntries);
        for (Map.Entry<String, BiomeConfigData.ToggleableBiomeEntry> biomeEntry : configData.islandBiomeEntries.entrySet()) {
            if (!revisedBiomeEntries.containsKey(biomeEntry.getKey())) continue;
            revisedBiomeEntries.put(biomeEntry.getKey(), biomeEntry.getValue());
        }
        configData.islandBiomeEntries = revisedBiomeEntries;
        JsonUtil.writeFile(BiomeRegistry.getConfigFile(), configData);
        for (DeferredRegistration registration : biomeRegistrations) {
            SingleClimateRegistrationData regData = (SingleClimateRegistrationData)registration.regData;
            String biomeName = regData.getBiome().m_135782_().toString();
            if (!revisedBiomeEntries.containsKey(biomeName)) continue;
            BiomeConfigData.ToggleableBiomeEntry entry = (BiomeConfigData.ToggleableBiomeEntry)revisedBiomeEntries.get(biomeName);
            if (entry.enabled) continue;
            ((SingleClimateRegistrationData)registration.regData).setWeight(0);
        }
    }

    public static void configureVanillaBiomes() {
        List<DeferredRegistration> biomeRegistrations = deferrances.get((Object)RegistrationType.VANILLA_BIOME);
        TreeMap defaultBiomeEntries = Maps.newTreeMap();
        HashMap regDataMap = Maps.newHashMap();
        for (DeferredRegistration registration : biomeRegistrations) {
            SingleClimateRegistrationData regData = (SingleClimateRegistrationData)registration.regData;
            String biomeName = ((SingleClimateRegistrationData)registration.regData).getBiome().m_135782_().toString();
            defaultBiomeEntries.put(biomeName, new BiomeConfigData.WeightedBiomeEntry(regData.getWeight()));
            regDataMap.put(biomeName, (SingleClimateRegistrationData)registration.regData);
        }
        BiomeConfigData defaultConfigData = new BiomeConfigData();
        defaultConfigData.vanillaBiomeEntries = defaultBiomeEntries;
        BiomeConfigData configData = BiomeRegistry.getConfigData(defaultConfigData);
        TreeMap revisedBiomeEntries = Maps.newTreeMap((SortedMap)defaultBiomeEntries);
        for (Map.Entry<String, BiomeConfigData.WeightedBiomeEntry> biomeEntry : configData.vanillaBiomeEntries.entrySet()) {
            if (!revisedBiomeEntries.containsKey(biomeEntry.getKey())) continue;
            revisedBiomeEntries.put(biomeEntry.getKey(), biomeEntry.getValue());
        }
        configData.vanillaBiomeEntries = revisedBiomeEntries;
        JsonUtil.writeFile(BiomeRegistry.getConfigFile(), configData);
        for (Map.Entry<String, BiomeConfigData.WeightedBiomeEntry> biomeEntry : configData.vanillaBiomeEntries.entrySet()) {
            String name = biomeEntry.getKey();
            BiomeConfigData.WeightedBiomeEntry islandBiomeEntry = biomeEntry.getValue();
            if (!regDataMap.containsKey(name)) continue;
            SingleClimateRegistrationData registrationData = (SingleClimateRegistrationData)regDataMap.get(name);
            registrationData.setWeight(islandBiomeEntry.weight);
        }
    }

    private static File getConfigDirFile() {
        Path bopConfigPath = Paths.get("config", "biomesoplenty");
        return bopConfigPath.toFile();
    }

    private static File getConfigFile() {
        return new File(BiomeRegistry.getConfigDirFile(), CONFIG_FILE_NAME);
    }

    private static BiomeConfigData getConfigData(BiomeConfigData defaultConfigData) {
        BiomeConfigData configData = JsonUtil.getOrCreateConfigFile(BiomeRegistry.getConfigDirFile(), CONFIG_FILE_NAME, defaultConfigData, new TypeToken<BiomeConfigData>(){}.getType());
        return configData;
    }

    private static <T extends IRegistrationData> void defer(RegistrationType type, T data) {
        if (!deferrances.containsKey((Object)type)) {
            deferrances.put(type, Lists.newArrayList());
        }
        List<DeferredRegistration> list = deferrances.get((Object)type);
        list.add(new DeferredRegistration<IRegistrationData>(type.regFunc, data));
    }

    public static void finalizeRegistrations(RegistrationType type) {
        if (!deferrances.containsKey((Object)type)) {
            return;
        }
        if (type == RegistrationType.SUB_BIOME) {
            HashSet children = Sets.newHashSet();
            deferrances.get((Object)RegistrationType.SUB_BIOME).forEach(reg -> {
                ResourceKey<Biome> biome = ((SubBiomeRegistrationData)reg.regData).getChild();
                if (children.contains(biome)) {
                    throw new RuntimeException(String.format("Sub biome %s cannot be added to multiple parents", biome.m_135782_().toString()));
                }
                children.add(biome);
            });
        }
        for (DeferredRegistration reg2 : deferrances.get((Object)type)) {
            reg2.register();
        }
    }

    public static enum RegistrationType {
        STANDARD_BIOME(data -> {
            Biome biome = data.getBiome();
            BiomeMetadata metadata = data.getMetadata();
            String name = data.getName();
            if (!metadata.getWeightMap().isEmpty() && (data.weightMap.isEmpty() || data.weightMap.entrySet().stream().allMatch(entry -> ((Integer)entry.getValue()).equals(0)))) {
                BiomesOPlenty.logger.debug("Weights absent for " + data.getName() + ", disabling...");
                return;
            }
            biome.setRegistryName(new ResourceLocation("biomesoplenty", name));
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
            for (Map.Entry entry2 : data.getWeights().entrySet()) {
                if (entry2 == null || (Integer)entry2.getValue() <= 0) continue;
                BOPClimates climate = (BOPClimates)((Object)((Object)entry2.getKey()));
                int weight = (Integer)entry2.getValue();
                BiomesOPlenty.logger.debug(String.format("%s weight set to %d for climate %s", name, weight, climate.name()));
                climate.addBiome(weight, BiomeUtil.createKey(data.getBiome()));
            }
            if (data.getMetadata() != null) {
                ModBiomes.biomeMetadata.put(BiomeUtil.createKey(data.getBiome()), data.getMetadata());
            }
        }),
        TECHNICAL_BIOME(data -> {
            Biome biome = data.getBiome();
            String name = data.getName();
            if (!data.getEnabled()) {
                BiomesOPlenty.logger.debug("Technical biome " + data.getName() + " is disabled.");
                return;
            }
            biome.setRegistryName(new ResourceLocation("biomesoplenty", name));
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
            if (data.getMetadata() != null) {
                ModBiomes.biomeMetadata.put(BiomeUtil.createKey(data.getBiome()), data.getMetadata());
            }
        }),
        SUB_BIOME(data -> {
            if (data.getWeight() == 0) {
                BiomesOPlenty.logger.debug("Weights absent for sub biome" + data.getChild().m_135782_().toString() + ", disabling...");
                return;
            }
            String childName = data.getChild().m_135782_().toString();
            BiomesOPlenty.logger.debug(String.format("Sub biome %s weight set to %d", childName, data.getWeight()));
            ModBiomes.subBiomes.put((Object)BiomeUtil.getBiomeId(data.getParent()), (Object)new ModBiomes.WeightedSubBiome(data.getChild(), data.getRarity(), data.getWeight()));
        }),
        ISLAND_BIOME(data -> {
            if (data.getWeight() == 0) {
                BiomesOPlenty.logger.debug("Weights absent for island biome" + data.getBiome().m_135782_().toString() + ", disabling...");
                return;
            }
            String biomeName = data.getBiome().m_135782_().toString();
            BiomesOPlenty.logger.debug(String.format("Island biome %s weight set to %d for climate %s", biomeName, data.getWeight(), data.getClimate().name()));
            ModBiomes.islandBiomeIds.add(BiomeUtil.getBiomeId(data.getBiome()));
            data.getClimate().addIslandBiome(data.getWeight(), data.getBiome());
        }),
        VANILLA_BIOME(data -> {
            if (data.getWeight() == 0) {
                BiomesOPlenty.logger.debug("Weights absent for vanilla biome" + data.getBiome().m_135782_().toString() + ", disabling...");
                return;
            }
            data.getClimate().addBiome(data.getWeight(), data.getBiome());
        });

        public final Consumer<? extends IRegistrationData> regFunc;

        private RegistrationType(Consumer<? extends IRegistrationData> regFunc) {
            this.regFunc = regFunc;
        }
    }

    private static class StandardBiomeRegistrationData
    extends TemplateRegistrationData {
        private final String name;
        private Map<BOPClimates, Integer> weightMap;

        public StandardBiomeRegistrationData(BiomeTemplate biome, String name) {
            super(biome);
            this.name = name;
            this.weightMap = Maps.newHashMap(this.getMetadata().getWeightMap());
            this.ensureSingleWeight();
        }

        public String getName() {
            return this.name;
        }

        public ImmutableMap<BOPClimates, Integer> getWeights() {
            return ImmutableMap.copyOf(this.weightMap);
        }

        public int getWeight(BOPClimates climate) {
            return this.weightMap.get((Object)climate);
        }

        public void setWeight(BOPClimates climate, int weight) {
            this.weightMap.put(climate, weight);
            this.ensureSingleWeight();
        }

        public Pair<BOPClimates, Integer> getPrimaryWeight() {
            ArrayList pairs = Lists.newArrayList();
            this.weightMap.entrySet().forEach(entry -> pairs.add(Pair.of((Object)((Object)((BOPClimates)((Object)((Object)entry.getKey())))), (Object)((Integer)entry.getValue()))));
            return (Pair)pairs.get(0);
        }

        public void setPrimaryWeight(int value) {
            BOPClimates climate = (BOPClimates)((Object)this.getPrimaryWeight().getKey());
            this.setWeight(climate, value);
        }

        private void ensureSingleWeight() {
            if (this.weightMap.size() > 1) {
                throw new RuntimeException(String.format("%s cannot be assigned to multiple climates!\n%s", new ResourceLocation("biomesoplenty", this.name).toString(), this.weightMap));
            }
        }
    }

    private static interface IRegistrationData {
    }

    private static class ToggleableStandardBiomeRegistrationData
    extends TemplateRegistrationData {
        private final String name;
        private boolean enabled;

        public ToggleableStandardBiomeRegistrationData(BiomeTemplate biome, String name, boolean enabled) {
            super(biome);
            this.name = name;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private static class SubBiomeRegistrationData
    implements IRegistrationData {
        private final ResourceKey<Biome> parent;
        private final ResourceKey<Biome> child;
        private int weight;
        private float rarity;

        public SubBiomeRegistrationData(ResourceKey<Biome> parent, ResourceKey<Biome> child, int weight, float rarity) {
            this.parent = parent;
            this.child = child;
            this.weight = weight;
            this.rarity = rarity;
        }

        public ResourceKey<Biome> getParent() {
            return this.parent;
        }

        public ResourceKey<Biome> getChild() {
            return this.child;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public float getRarity() {
            return this.rarity;
        }

        public void setRarity(float rarity) {
            this.rarity = rarity;
        }
    }

    private static class SingleClimateRegistrationData
    implements IRegistrationData {
        private final BOPClimates climate;
        private final ResourceKey<Biome> biome;
        private int weight;

        public SingleClimateRegistrationData(ResourceKey<Biome> biome, BOPClimates climate, int weight) {
            this.biome = biome;
            this.climate = climate;
            this.weight = weight;
        }

        public ResourceKey<Biome> getBiome() {
            return this.biome;
        }

        public BOPClimates getClimate() {
            return this.climate;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }

    private static class DeferredRegistration<T extends IRegistrationData> {
        private final Consumer<T> regFunc;
        private final T regData;

        public DeferredRegistration(Consumer<T> regFunc, T regData) {
            this.regFunc = regFunc;
            this.regData = regData;
        }

        public void register() {
            this.regFunc.accept(this.regData);
        }
    }

    private static abstract class TemplateRegistrationData
    implements IRegistrationData {
        private final Biome biome;
        private final BiomeMetadata metadata;

        public TemplateRegistrationData(BiomeTemplate template) {
            this.biome = template.build();
            this.metadata = template.buildMetadata();
        }

        public TemplateRegistrationData(Biome biome) {
            this.biome = biome;
            this.metadata = null;
        }

        public Biome getBiome() {
            return this.biome;
        }

        @Nullable
        public BiomeMetadata getMetadata() {
            return this.metadata;
        }
    }
}

