/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class BiomeTemplate {
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    private ResourceKey<Biome> beachBiome = Biomes.f_48217_;
    private ResourceKey<Biome> riverBiome = Biomes.f_48208_;
    private BiFunction<Double, Double, Integer> foliageColorFunction;
    private BiFunction<Double, Double, Integer> grassColorFunction;
    private BiFunction<Double, Double, Integer> waterColorFunction;

    protected void configureBiome(Biome.BiomeBuilder builder) {
    }

    protected void configureGeneration(BiomeGenerationSettings.Builder builder) {
    }

    protected void configureMobSpawns(MobSpawnSettings.Builder builder) {
    }

    protected void configureDefaultMobSpawns(MobSpawnSettings.Builder builder) {
        builder.m_48367_();
    }

    public final Biome build() {
        Biome.BiomeBuilder biomeBuilder = new Biome.BiomeBuilder();
        BiomeGenerationSettings.Builder biomeGenBuilder = new BiomeGenerationSettings.Builder();
        this.configureGeneration(biomeGenBuilder);
        biomeBuilder.m_47601_(biomeGenBuilder.m_47831_());
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        this.configureDefaultMobSpawns(mobSpawnBuilder);
        this.configureMobSpawns(mobSpawnBuilder);
        biomeBuilder.m_47605_(mobSpawnBuilder.m_48381_());
        this.configureBiome(biomeBuilder);
        return biomeBuilder.m_47592_();
    }

    public final BiomeMetadata buildMetadata() {
        return new BiomeMetadata(this.weightMap, this.beachBiome, this.riverBiome, this.foliageColorFunction, this.grassColorFunction, this.waterColorFunction);
    }

    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    public void setBeachBiome(ResourceKey<Biome> biome) {
        this.beachBiome = biome;
    }

    public void setRiverBiome(ResourceKey<Biome> biome) {
        this.riverBiome = biome;
    }

    public void setFoliageColorFunction(BiFunction<Double, Double, Integer> func) {
        this.foliageColorFunction = func;
    }

    public void setGrassColorFunction(BiFunction<Double, Double, Integer> func) {
        this.grassColorFunction = func;
    }

    public void setWaterColorFunction(BiFunction<Double, Double, Integer> func) {
        this.waterColorFunction = func;
    }

    public static int calculateSkyColor(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = Mth.m_14036_((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

