/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.common.biome.BiomeTemplate;
import biomesoplenty.common.world.gen.feature.BOPConfiguredFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Features;
import net.minecraft.data.worldgen.SurfaceBuilders;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class RainbowHillsBiome
extends BiomeTemplate {
    public RainbowHillsBiome() {
        this.setBeachBiome(null);
        this.setGrassColorFunction(this::getGrassColor);
    }

    @Override
    protected void configureBiome(Biome.BiomeBuilder builder) {
        builder.m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47593_(0.5f).m_47607_(0.5f).m_47609_(0.55f).m_47611_(1.0f);
        builder.m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4566514).m_48037_(267827).m_48019_(12638463).m_48040_(RainbowHillsBiome.calculateSkyColor(0.55f)).m_48045_(7720589).m_48043_(this.getFoliageColor()).m_48027_(AmbientMoodSettings.f_47387_).m_48018_());
    }

    @Override
    protected void configureGeneration(BiomeGenerationSettings.Builder builder) {
        builder.m_47851_(SurfaceBuilders.f_127285_);
        BiomeDefaultFeatures.m_126777_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126790_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126798_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.RAINBOW_HILLS_TREES);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.RAINBOW_HILLS_FLOWERS);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.BLUE_HYDRANGEA_4);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.CLOVER_6);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.GOLDENROD_2);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.LILAC_2);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.PEONY_1);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.ROSE_BUSH_4);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.SPROUTS_5);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.STANDARD_GRASS_12);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Features.f_126909_);
        builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, Features.f_126910_);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    @Override
    protected void configureMobSpawns(MobSpawnSettings.Builder builder) {
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 8, 4, 4));
        builder.m_48376_(MobCategory.UNDERGROUND_WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147034_, 10, 4, 6));
        builder.m_48376_(MobCategory.UNDERGROUND_WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 10, 4, 6));
        builder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
    }

    public int getGrassColor(double x, double z) {
        double d0 = Biome.f_47433_.m_75449_(x * 0.0225, z * 0.0225, false);
        return d0 < -0.1 ? 7851647 : 7720589;
    }

    public int getFoliageColor() {
        return 7720589;
    }
}

