/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.init.ModBiomes;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeUtil {
    public static Registry<Biome> DYNAMIC_REGISTRY = null;

    public static ResourceKey<Biome> createKey(Biome biome) {
        return biome == null ? null : ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BiomeUtil.registry().m_7981_((Object)biome));
    }

    private static Registry<Biome> registry() {
        return DYNAMIC_REGISTRY == null ? BuiltinRegistries.f_123865_ : DYNAMIC_REGISTRY;
    }

    public static ResourceKey<Biome> createKey(int id) {
        return BiomeUtil.createKey(BiomeUtil.getBiome(id));
    }

    public static Biome getBiome(ResourceKey<Biome> key) {
        Biome biome = (Biome)BiomeUtil.registry().m_6246_(key);
        if (biome == null) {
            throw new RuntimeException("Attempted to get unregistered biome " + key);
        }
        return biome;
    }

    public static Biome getBiome(int id) {
        if (id == -1) {
            throw new RuntimeException("Attempted to get biome with id -1");
        }
        return (Biome)BiomeUtil.registry().m_7942_(id);
    }

    public static int getBiomeId(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Attempted to get id of null biome");
        }
        int id = BiomeUtil.registry().m_7447_((Object)biome);
        if (id == -1) {
            throw new RuntimeException("Biome id is -1 for biome " + BiomeUtil.registry().m_7981_((Object)biome));
        }
        return id;
    }

    public static int getBiomeId(ResourceKey<Biome> key) {
        return BiomeUtil.getBiomeId(BiomeUtil.getBiome(key));
    }

    public static boolean hasMetadata(ResourceKey<Biome> key) {
        return ModBiomes.biomeMetadata.containsKey(key);
    }

    public static boolean hasMetadata(Biome biome) {
        return BiomeUtil.hasMetadata(BiomeUtil.createKey(biome));
    }

    public static BiomeMetadata getMetadata(ResourceKey<Biome> key) {
        return ModBiomes.biomeMetadata.get(key);
    }

    public static BiomeMetadata getMetadata(Biome biome) {
        return BiomeUtil.getMetadata(BiomeUtil.createKey(biome));
    }

    public static boolean exists(ResourceKey<Biome> key) {
        return BiomeUtil.registry().m_7804_(key.m_135782_());
    }

    public static boolean exists(int id) {
        return BiomeUtil.getBiome(id) != null;
    }

    @Nullable
    public static ResourceKey<Biome> getClientKey(Biome biome) {
        return Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)biome).orElse(null);
    }
}

