/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import biomesoplenty.common.world.BOPOverworldGenSettings;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.biome.Biomes;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.newbiome.layer.Layer;

public class BOPBiomeProvider
extends BiomeSource {
    public static final Codec<BOPBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(biomeProvider -> biomeProvider.seed), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(biomeProvider -> biomeProvider.biomes)).apply((Applicative)builder, builder.stable(BOPBiomeProvider::new)));
    private static final List<ResourceKey<Biome>> VANILLA_POSSIBLE_BIOMES = ImmutableList.of((Object)net.minecraft.world.level.biome.Biomes.f_48174_, (Object)net.minecraft.world.level.biome.Biomes.f_48202_, (Object)net.minecraft.world.level.biome.Biomes.f_48203_, (Object)net.minecraft.world.level.biome.Biomes.f_48204_, (Object)net.minecraft.world.level.biome.Biomes.f_48205_, (Object)net.minecraft.world.level.biome.Biomes.f_48206_, (Object)net.minecraft.world.level.biome.Biomes.f_48207_, (Object)net.minecraft.world.level.biome.Biomes.f_48208_, (Object)net.minecraft.world.level.biome.Biomes.f_48211_, (Object)net.minecraft.world.level.biome.Biomes.f_48212_, (Object)net.minecraft.world.level.biome.Biomes.f_48213_, (Object)net.minecraft.world.level.biome.Biomes.f_48214_, (Object[])new ResourceKey[]{net.minecraft.world.level.biome.Biomes.f_48215_, net.minecraft.world.level.biome.Biomes.f_48216_, net.minecraft.world.level.biome.Biomes.f_48217_, net.minecraft.world.level.biome.Biomes.f_48218_, net.minecraft.world.level.biome.Biomes.f_48219_, net.minecraft.world.level.biome.Biomes.f_48220_, net.minecraft.world.level.biome.Biomes.f_48221_, net.minecraft.world.level.biome.Biomes.f_48222_, net.minecraft.world.level.biome.Biomes.f_48223_, net.minecraft.world.level.biome.Biomes.f_48224_, net.minecraft.world.level.biome.Biomes.f_48225_, net.minecraft.world.level.biome.Biomes.f_48226_, net.minecraft.world.level.biome.Biomes.f_48148_, net.minecraft.world.level.biome.Biomes.f_48149_, net.minecraft.world.level.biome.Biomes.f_48150_, net.minecraft.world.level.biome.Biomes.f_48151_, net.minecraft.world.level.biome.Biomes.f_48152_, net.minecraft.world.level.biome.Biomes.f_48153_, net.minecraft.world.level.biome.Biomes.f_48154_, net.minecraft.world.level.biome.Biomes.f_48155_, net.minecraft.world.level.biome.Biomes.f_48156_, net.minecraft.world.level.biome.Biomes.f_48157_, net.minecraft.world.level.biome.Biomes.f_48158_, net.minecraft.world.level.biome.Biomes.f_48159_, net.minecraft.world.level.biome.Biomes.f_48160_, net.minecraft.world.level.biome.Biomes.f_48161_, net.minecraft.world.level.biome.Biomes.f_48166_, net.minecraft.world.level.biome.Biomes.f_48167_, net.minecraft.world.level.biome.Biomes.f_48168_, net.minecraft.world.level.biome.Biomes.f_48169_, net.minecraft.world.level.biome.Biomes.f_48170_, net.minecraft.world.level.biome.Biomes.f_48171_, net.minecraft.world.level.biome.Biomes.f_48172_, net.minecraft.world.level.biome.Biomes.f_48176_, net.minecraft.world.level.biome.Biomes.f_48177_, net.minecraft.world.level.biome.Biomes.f_48178_, net.minecraft.world.level.biome.Biomes.f_48179_, net.minecraft.world.level.biome.Biomes.f_48180_, net.minecraft.world.level.biome.Biomes.f_48181_, net.minecraft.world.level.biome.Biomes.f_48182_, net.minecraft.world.level.biome.Biomes.f_48183_, net.minecraft.world.level.biome.Biomes.f_48184_, net.minecraft.world.level.biome.Biomes.f_48185_, net.minecraft.world.level.biome.Biomes.f_48186_, net.minecraft.world.level.biome.Biomes.f_48187_, net.minecraft.world.level.biome.Biomes.f_48188_, net.minecraft.world.level.biome.Biomes.f_48189_, net.minecraft.world.level.biome.Biomes.f_48190_, net.minecraft.world.level.biome.Biomes.f_48191_, net.minecraft.world.level.biome.Biomes.f_48192_, net.minecraft.world.level.biome.Biomes.f_48193_, net.minecraft.world.level.biome.Biomes.f_48194_, net.minecraft.world.level.biome.Biomes.f_48195_, net.minecraft.world.level.biome.Biomes.f_48196_});
    private final long seed;
    private final Layer noiseBiomeLayer;
    private final Registry<Biome> biomes;

    public BOPBiomeProvider(long seed, Registry<Biome> biomes) {
        super(Stream.concat(VANILLA_POSSIBLE_BIOMES.stream(), BOPClimates.getOverworldBiomes().stream()).map(arg_0 -> biomes.m_6246_(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.noiseBiomeLayer = BOPLayerUtil.createGenLayers(seed, new BOPOverworldGenSettings());
        this.biomes = biomes;
        BiomeUtil.DYNAMIC_REGISTRY = biomes;
        for (Biome biome : biomes) {
            int id = biomes.m_7447_((Object)biome);
            if (Biomes.f_127323_.containsKey(id)) continue;
            Biomes.f_127323_.put(id, (Object)((ResourceKey)biomes.m_7854_((Object)biome).get()));
        }
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long seed) {
        return new BOPBiomeProvider(seed, this.biomes);
    }

    public Biome m_7158_(int x, int y, int z) {
        return this.noiseBiomeLayer.m_76715_(this.biomes, x, z);
    }
}

