/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPOverworldGenSettings;
import biomesoplenty.common.world.layer.BOPBiomeEdgeLayer;
import biomesoplenty.common.world.layer.BOPBiomeLayer;
import biomesoplenty.common.world.layer.BOPMixOceansLayer;
import biomesoplenty.common.world.layer.BOPRiverMixLayer;
import biomesoplenty.common.world.layer.BOPShoreLayer;
import biomesoplenty.common.world.layer.ClimateLayer;
import biomesoplenty.common.world.layer.LargeIslandLayer;
import biomesoplenty.common.world.layer.RainfallNoiseLayer;
import biomesoplenty.common.world.layer.RainfallRandomLayer;
import biomesoplenty.common.world.layer.SubBiomeLayer;
import biomesoplenty.common.world.layer.TemperatureLatitudeLayer;
import biomesoplenty.common.world.layer.TemperatureNoiseLayer;
import biomesoplenty.common.world.layer.TemperatureRandomLayer;
import biomesoplenty.common.world.layer.traits.LazyAreaLayerContextBOP;
import java.util.function.LongFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.area.AreaFactory;
import net.minecraft.world.level.newbiome.context.BigContext;
import net.minecraft.world.level.newbiome.layer.AddDeepOceanLayer;
import net.minecraft.world.level.newbiome.layer.AddIslandLayer;
import net.minecraft.world.level.newbiome.layer.AddMushroomIslandLayer;
import net.minecraft.world.level.newbiome.layer.IslandLayer;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraft.world.level.newbiome.layer.Layers;
import net.minecraft.world.level.newbiome.layer.OceanLayer;
import net.minecraft.world.level.newbiome.layer.RareBiomeLargeLayer;
import net.minecraft.world.level.newbiome.layer.RareBiomeSpotLayer;
import net.minecraft.world.level.newbiome.layer.RemoveTooMuchOceanLayer;
import net.minecraft.world.level.newbiome.layer.RiverInitLayer;
import net.minecraft.world.level.newbiome.layer.RiverLayer;
import net.minecraft.world.level.newbiome.layer.SmoothLayer;
import net.minecraft.world.level.newbiome.layer.ZoomLayer;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer1;

public class BOPLayerUtil {
    public static final int WARM_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48166_);
    public static final int LUKEWARM_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48167_);
    public static final int OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48174_);
    public static final int COLD_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48168_);
    public static final int FROZEN_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48211_);
    public static final int DEEP_WARM_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48169_);
    public static final int DEEP_LUKEWARM_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48170_);
    public static final int DEEP_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48225_);
    public static final int DEEP_COLD_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48171_);
    public static final int DEEP_FROZEN_OCEAN = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48172_);

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createInitialLandAndSeaFactory(LongFunction<C> contextFactory) {
        AreaFactory factory = IslandLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.m_77002_((BigContext)contextFactory.apply(2000L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1L), factory);
        factory = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2001L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(2L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(50L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(70L), factory);
        factory = RemoveTooMuchOceanLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(2L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(3L), factory);
        factory = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2002L), factory);
        factory = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2003L), factory);
        factory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(4L), factory);
        return factory;
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createClimateFactory(LongFunction<C> contextFactory, BOPOverworldGenSettings settings) {
        return ClimateLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(103L), switch (settings.getTempScheme()) {
            default -> TemperatureLatitudeLayer.INSTANCE.run((BigContext)contextFactory.apply(2L));
            case BOPOverworldGenSettings.TemperatureVariationScheme.SMALL_ZONES -> TemperatureNoiseLayer.SMALL_ZONES.run((BigContext)contextFactory.apply(3L));
            case BOPOverworldGenSettings.TemperatureVariationScheme.MEDIUM_ZONES -> TemperatureNoiseLayer.MEDIUM_ZONES.run((BigContext)contextFactory.apply(4L));
            case BOPOverworldGenSettings.TemperatureVariationScheme.LARGE_ZONES -> TemperatureNoiseLayer.LARGE_ZONES.run((BigContext)contextFactory.apply(5L));
            case BOPOverworldGenSettings.TemperatureVariationScheme.RANDOM -> TemperatureRandomLayer.INSTANCE.run((BigContext)contextFactory.apply(6L));
        }, switch (settings.getRainScheme()) {
            case BOPOverworldGenSettings.RainfallVariationScheme.SMALL_ZONES -> RainfallNoiseLayer.SMALL_ZONES.run((BigContext)contextFactory.apply(7L));
            default -> RainfallNoiseLayer.MEDIUM_ZONES.run((BigContext)contextFactory.apply(8L));
            case BOPOverworldGenSettings.RainfallVariationScheme.LARGE_ZONES -> RainfallNoiseLayer.LARGE_ZONES.run((BigContext)contextFactory.apply(9L));
            case BOPOverworldGenSettings.RainfallVariationScheme.RANDOM -> RainfallRandomLayer.INSTANCE.run((BigContext)contextFactory.apply(10L));
        });
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createBiomeFactory(AreaFactory<T> landSeaAreaFactory, AreaFactory<T> climateAreaFactory, LongFunction<C> contextFactory) {
        AreaFactory biomeFactory = BOPBiomeLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(200L), landSeaAreaFactory, climateAreaFactory);
        biomeFactory = RareBiomeLargeLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1001L), biomeFactory);
        biomeFactory = Layers.m_76729_((long)1000L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)biomeFactory, (int)2, contextFactory);
        biomeFactory = BOPBiomeEdgeLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), biomeFactory);
        return biomeFactory;
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createAreaFactories(BOPOverworldGenSettings settings, LongFunction<C> contextFactory) {
        int biomeSize;
        AreaFactory landSeaFactory = BOPLayerUtil.createInitialLandAndSeaFactory(contextFactory);
        AreaFactory oceanBiomeFactory = OceanLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(2L));
        oceanBiomeFactory = Layers.m_76729_((long)2001L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)oceanBiomeFactory, (int)6, contextFactory);
        int riverSize = biomeSize = 4;
        if (settings != null) {
            biomeSize = settings.getBiomeSize();
            riverSize = settings.getRiverSize();
        }
        AreaFactory climateFactory = BOPLayerUtil.createClimateFactory(contextFactory, settings);
        landSeaFactory = AddMushroomIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(5L), landSeaFactory);
        landSeaFactory = LargeIslandLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(5L), landSeaFactory, climateFactory);
        landSeaFactory = AddDeepOceanLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(4L), landSeaFactory);
        AreaFactory biomesFactory = BOPLayerUtil.createBiomeFactory(landSeaFactory, climateFactory, contextFactory);
        AreaFactory riverAndSubBiomesInitFactory = RiverInitLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(100L), landSeaFactory);
        riverAndSubBiomesInitFactory = Layers.m_76729_((long)1000L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)riverAndSubBiomesInitFactory, (int)2, contextFactory);
        biomesFactory = SubBiomeLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(1000L), biomesFactory, riverAndSubBiomesInitFactory);
        AreaFactory riversInitFactory = Layers.m_76729_((long)1000L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)riverAndSubBiomesInitFactory, (int)riverSize, contextFactory);
        riversInitFactory = RiverLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1L), riversInitFactory);
        riversInitFactory = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), riversInitFactory);
        biomesFactory = RareBiomeSpotLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1001L), biomesFactory);
        for (int i = 0; i < biomeSize; ++i) {
            biomesFactory = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(1000 + i), biomesFactory);
            if (i == 0) {
                biomesFactory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(3L), biomesFactory);
            }
            if (i != 1 && biomeSize != 1) continue;
            biomesFactory = BOPShoreLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), biomesFactory);
        biomesFactory = BOPRiverMixLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(100L), biomesFactory, riversInitFactory);
        climateFactory = Layers.m_76729_((long)2001L, (AreaTransformer1)ZoomLayer.NORMAL, climateFactory, (int)(biomeSize + 2), contextFactory);
        biomesFactory = BOPMixOceansLayer.INSTANCE.run((BigContext)contextFactory.apply(100L), biomesFactory, oceanBiomeFactory, climateFactory);
        return biomesFactory;
    }

    public static Layer createGenLayers(long seed, BOPOverworldGenSettings settings) {
        AreaFactory factory = BOPLayerUtil.createAreaFactories(settings, seedModifier -> new LazyAreaLayerContextBOP(1, seed, seedModifier));
        return new Layer(factory);
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }
}

