/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.world.BOPNetherLayerUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.layer.Layer;

public class BOPNetherBiomeProvider
extends BiomeSource {
    public static final Codec<BOPNetherBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(biomeProvider -> biomeProvider.seed), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(biomeProvider -> biomeProvider.biomes)).apply((Applicative)builder, builder.stable(BOPNetherBiomeProvider::new)));
    private static final List<ResourceKey<Biome>> VANILLA_POSSIBLE_BIOMES = ImmutableList.of((Object)Biomes.f_48209_, (Object)Biomes.f_48199_, (Object)Biomes.f_48200_, (Object)Biomes.f_48201_, (Object)Biomes.f_48175_);
    private final long seed;
    private final Layer noiseBiomeLayer;
    private final Registry<Biome> biomes;

    public BOPNetherBiomeProvider(long seed, Registry<Biome> biomes) {
        super(Stream.concat(VANILLA_POSSIBLE_BIOMES.stream(), BOPClimates.NETHER.getLandBiomes().stream().map(entry -> entry.biome)).map(arg_0 -> biomes.m_6246_(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.noiseBiomeLayer = BOPNetherLayerUtil.createGenLayers(seed);
        this.biomes = biomes;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long seed) {
        return new BOPNetherBiomeProvider(seed, this.biomes);
    }

    public Biome m_7158_(int x, int y, int z) {
        return this.noiseBiomeLayer.m_76715_(this.biomes, x, z);
    }
}

