/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.layer.BOPShoreLayer;
import biomesoplenty.common.world.layer.LandLayer;
import biomesoplenty.common.world.layer.NetherBiomeLayer;
import biomesoplenty.common.world.layer.traits.LazyAreaLayerContextBOP;
import java.util.function.LongFunction;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.area.AreaFactory;
import net.minecraft.world.level.newbiome.context.BigContext;
import net.minecraft.world.level.newbiome.layer.AddIslandLayer;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraft.world.level.newbiome.layer.Layers;
import net.minecraft.world.level.newbiome.layer.SmoothLayer;
import net.minecraft.world.level.newbiome.layer.ZoomLayer;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer1;

public class BOPNetherLayerUtil {
    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createBiomeFactory(AreaFactory<T> landFactory, LongFunction<C> contextFactory) {
        AreaFactory biomeFactory = NetherBiomeLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(200L));
        biomeFactory = Layers.m_76729_((long)1000L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)biomeFactory, (int)2, contextFactory);
        return biomeFactory;
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> createAreaFactories(LongFunction<C> contextFactory) {
        int biomeSize = 4;
        AreaFactory landFactory = LandLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(1L));
        AreaFactory biomesFactory = BOPNetherLayerUtil.createBiomeFactory(landFactory, contextFactory);
        for (int i = 0; i < biomeSize; ++i) {
            biomesFactory = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(1000 + i), biomesFactory);
            if (i == 0) {
                biomesFactory = AddIslandLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(3L), biomesFactory);
            }
            if (i != 1 && biomeSize != 1) continue;
            biomesFactory = BOPShoreLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), biomesFactory);
        return biomesFactory;
    }

    public static Layer createGenLayers(long seed) {
        AreaFactory factory = BOPNetherLayerUtil.createAreaFactories(seedModifier -> new LazyAreaLayerContextBOP(1, seed, seedModifier));
        return new Layer(factory);
    }
}

