/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import java.util.Arrays;
import java.util.Random;

public final class SimplexNoise {
    private static final long PRIME_X = 6026932503003350773L;
    private static final long PRIME_Y = 6614699811220273867L;
    private static final long HASH_UNIQUIFIER = 9075803285180240909L;
    private static final double F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
    private static final double G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
    public static final double TRIANGLE_START_X = 0.6666666666666666 - G2;
    public static final double TRIANGLE_START_Y = 0.3333333333333333 - G2;
    private static final float[] grads = new float[]{0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f, 0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f, 0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f, 0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f, 0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9238795f, 0.38268343f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.9238795f, -0.38268343f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.38268343f, -0.9238795f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.38268343f, -0.9238795f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9238795f, -0.38268343f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.9238795f, 0.38268343f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.38268343f, 0.9238795f, -0.13052619f, 0.9914449f, 0.38268343f, 0.9238795f, 0.9238795f, 0.38268343f, 0.9238795f, -0.38268343f, 0.38268343f, -0.9238795f, -0.38268343f, -0.9238795f, -0.9238795f, -0.38268343f, -0.9238795f, 0.38268343f, -0.38268343f, 0.9238795f};
    private static final double N2 = 0.01001634121365712;

    private SimplexNoise() {
    }

    public static double noise(long seed, double xin, double yin) {
        double t2;
        double t1;
        int j1;
        int i1;
        double originY0;
        double y0;
        int j;
        double t;
        double s = (xin + yin) * F2;
        int i = SimplexNoise.fastfloor(xin + s);
        double originX0 = (double)i - (t = (double)(i + (j = SimplexNoise.fastfloor(yin + s))) * G2);
        double x0 = xin - originX0;
        if (x0 > (y0 = yin - (originY0 = (double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 - (1.0 - 2.0 * G2);
        double y2 = y0 - (1.0 - 2.0 * G2);
        long xsvp = (long)i * 6026932503003350773L;
        long ysvp = (long)j * 6614699811220273867L;
        double value = 0.0;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 > 0.0) {
            t0 *= t0;
            value = t0 * t0 * SimplexNoise.grad(seed, xsvp, ysvp, x0, y0);
        }
        if ((t1 = 0.5 - x1 * x1 - y1 * y1) > 0.0) {
            t1 *= t1;
            value += t1 * t1 * SimplexNoise.grad(seed, xsvp + ((long)(-i1) & 0x53A3F72DEEC546F5L), ysvp + ((long)(-j1) & 0x5BCC226E9FA0BACBL), x1, y1);
        }
        if ((t2 = 0.5 - x2 * x2 - y2 * y2) > 0.0) {
            t2 *= t2;
            value += t2 * t2 * SimplexNoise.grad(seed, xsvp + 6026932503003350773L, ysvp + 6614699811220273867L, x2, y2);
        }
        return value;
    }

    private static int fastfloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static double grad(long seed, long xsvp, long ysvp, double dx, double dy) {
        long hash = seed ^ xsvp ^ ysvp;
        hash *= 9075803285180240909L;
        hash ^= hash >> 31;
        hash ^= hash >> 17;
        hash ^= hash >> 9;
        int index = (int)(hash & 0xFEL);
        return (double)grads[index] * dx + (double)grads[index | 1] * dy;
    }

    public static void main(String[] args) {
        int i;
        long renderSeed = 1349226349613393113L;
        int width = 120;
        int height = 28;
        double freqX = 0.030303030303030304;
        double freqY = 0.08333333333333333;
        String grayscaleAscii = " .:-=+*#%@";
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double noise = SimplexNoise.noise(renderSeed, (double)x * freqX, (double)y * freqY);
                int asciiGrayscaleLevel = (int)((noise = noise * 0.5 + 0.5) * (double)grayscaleAscii.length());
                if (asciiGrayscaleLevel < 0) {
                    asciiGrayscaleLevel = 0;
                } else if (asciiGrayscaleLevel > grayscaleAscii.length()) {
                    asciiGrayscaleLevel = grayscaleAscii.length() - 1;
                }
                System.out.print(grayscaleAscii.charAt(asciiGrayscaleLevel));
            }
            System.out.println();
        }
        int numGroups = 9;
        int numEvalsPerGroup = 0x100000;
        double evalAreaRange = 128.0;
        int randomSeed = 12345;
        Random coordRandom = new Random(randomSeed);
        double[] evals = new double[numGroups * numEvalsPerGroup * 2];
        for (i = 0; i < evals.length; i += 2) {
            double value;
            evals[i + 0] = value = SimplexNoise.noise(coordRandom.nextLong(), coordRandom.nextDouble() * evalAreaRange, coordRandom.nextDouble() * evalAreaRange);
            evals[i + 1] = -value;
        }
        Arrays.sort(evals);
        for (i = 0; i < numGroups - 1; ++i) {
            int boundIndex = (i + 1) * (numEvalsPerGroup * 2);
            double bound = (evals[boundIndex] + evals[boundIndex - 1]) * 0.5;
            if (i != 0) {
                System.out.print("else ");
            }
            System.out.println("if (noiseVal < " + bound + ") return " + i + ";");
        }
        System.out.print("else return " + (numGroups - 1) + ";");
    }

    static {
        int i = 0;
        while (i < grads.length) {
            int n = i++;
            grads[n] = (float)((double)grads[n] / 0.01001634121365712);
        }
    }
}

