/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class NetherVinesFeature
extends Feature<NoneFeatureConfiguration> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50134_;
    protected IBlockPosQuery replace = (world, pos) -> NetherVinesFeature.m_65810_((LevelSimulatedReader)world, (BlockPos)pos);
    int minHeight = 8;
    int maxHeight = 20;

    public NetherVinesFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        Random rand = featurePlaceContext.m_159776_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() > 1 && this.replace.matches((LevelAccessor)world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches((LevelAccessor)world, startPos.m_142082_(2, 0, 2))) {
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.m_142082_(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.replace.matches((LevelAccessor)world, genPos) || !this.placeOn.matches((LevelAccessor)world, genPos.m_7494_())) continue;
            BlockState vineState = BOPBlocks.WILLOW_VINE.m_49966_();
            ArrayList validDirections = Lists.newArrayList();
            for (Direction facing : Direction.values()) {
                if (facing == Direction.UP || facing == Direction.DOWN || !this.placeOn.matches((LevelAccessor)world, genPos.m_142300_(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            Direction direction = (Direction)validDirections.get(rand.nextInt(validDirections.size()));
            vineState = (BlockState)vineState.m_61124_((Property)VineBlock.m_57883_((Direction)direction), (Comparable)Boolean.valueOf(true));
            int targetHeight = this.minHeight + rand.nextInt(this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                BlockPos offsetPos = genPos.m_6625_(height);
                if (!this.replace.matches((LevelAccessor)world, offsetPos) || !vineState.m_60734_().m_7898_(vineState, (LevelReader)world, offsetPos)) {
                    return false;
                }
                world.m_7731_(offsetPos, vineState, 2);
            }
        }
        return true;
    }

    public boolean setBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }
}

