/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.BOPFeatureUtil;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class BasicTreeFeature
extends TreeFeatureBase {
    protected int leafLayers;
    protected int leavesOffset;
    protected int maxLeavesRadius;
    protected int leavesLayerHeight;
    protected IBlockPosQuery placeVinesOn;
    protected float hangingChance;

    protected BasicTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int leafLayers, int leavesOffset, int maxLeavesRadius, int leavesLayerHeight, IBlockPosQuery placeVinesOn, float hangingChance) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.leafLayers = leafLayers;
        this.leavesOffset = leavesOffset;
        this.maxLeavesRadius = maxLeavesRadius;
        this.leavesLayerHeight = leavesLayerHeight;
        this.placeVinesOn = placeVinesOn;
        this.hangingChance = hangingChance;
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= 1 && pos.m_123342_() + height + 1 <= 256) {
            for (int y = pos.m_123342_(); y <= pos.m_123342_() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.m_123342_()) {
                    radius = 0;
                }
                if (y >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius && hasSpace; ++x) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            boolean isSoil = BOPFeatureUtil.isSoil((LevelReader)world, soilPos);
            if (this.placeOn.matches(world, soilPos) && isSoil && pos.m_123342_() < 256 - height - 1) {
                int x;
                int leavesRadius;
                int currentLayer;
                int y;
                world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
                int leavesLayers = this.leafLayers - 1;
                for (y = pos.m_123342_() + height - leavesLayers; y <= pos.m_123342_() + height; ++y) {
                    currentLayer = y - (pos.m_123342_() + height);
                    leavesRadius = this.maxLeavesRadius - currentLayer / this.leavesLayerHeight;
                    for (x = pos.m_123341_() - leavesRadius; x <= pos.m_123341_() + leavesRadius; ++x) {
                        int xDiff = x - pos.m_123341_();
                        for (int z = pos.m_123343_() - leavesRadius; z <= pos.m_123343_() + leavesRadius; ++z) {
                            BlockPos leavesPos;
                            int zDiff = z - pos.m_123343_();
                            if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.nextInt(2) == 0 || currentLayer == 0) || !this.replace.matches(world, leavesPos = new BlockPos(x, y, z))) continue;
                            if (this.altLeaves != Blocks.f_50016_.m_49966_()) {
                                if (random.nextInt(4) == 0) {
                                    this.placeAltLeaves(world, leavesPos, leaves);
                                    continue;
                                }
                                this.placeLeaves(world, leavesPos, leaves);
                                continue;
                            }
                            this.placeLeaves(world, leavesPos, leaves);
                        }
                    }
                }
                this.generateTrunk(world, pos, height, logs);
                if (this.vine != Blocks.f_50016_.m_49966_()) {
                    for (y = pos.m_123342_() - leavesLayers + height; y <= pos.m_123342_() + height; ++y) {
                        currentLayer = y - (pos.m_123342_() + height);
                        leavesRadius = this.maxLeavesRadius + this.leavesOffset - currentLayer / this.leavesLayerHeight;
                        for (x = pos.m_123341_() - leavesRadius; x <= pos.m_123341_() + leavesRadius; ++x) {
                            for (int z = pos.m_123343_() - leavesRadius; z <= pos.m_123343_() + leavesRadius; ++z) {
                                BlockPos blockpos3 = new BlockPos(x, y, z);
                                if (world.m_8055_(blockpos3).m_60767_() != Material.f_76274_) continue;
                                BlockPos westPos = blockpos3.m_142125_();
                                BlockPos eastPos = blockpos3.m_142126_();
                                BlockPos northPos = blockpos3.m_142127_();
                                BlockPos southPos = blockpos3.m_142128_();
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, westPos)) {
                                    this.extendVines(world, westPos, Direction.EAST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, eastPos)) {
                                    this.extendVines(world, eastPos, Direction.WEST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, northPos)) {
                                    this.extendVines(world, northPos, Direction.SOUTH);
                                }
                                if (random.nextInt(4) != 0 || !this.placeVinesOn.matches(world, southPos)) continue;
                                this.extendVines(world, southPos, Direction.NORTH);
                            }
                        }
                    }
                }
                if (this.hanging != Blocks.f_50016_.m_49966_()) {
                    this.generateHanging(world, pos, random, height);
                }
                if (this.trunkFruit != Blocks.f_50016_.m_49966_() && random.nextInt(5) == 0 && height > 5) {
                    for (int l3 = 0; l3 < 2; ++l3) {
                        for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                            if (random.nextInt(4 - l3) != 0) continue;
                            Direction Direction1 = Direction2.m_122424_();
                            this.generateTrunkFruit(world, random.nextInt(3), pos.m_142082_(Direction1.m_122429_(), height - 5 + l3, Direction1.m_122431_()), Direction2);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(LevelAccessor world, BlockPos start, int height, BiConsumer<BlockPos, BlockState> logs) {
        for (int layer = 0; layer < height; ++layer) {
            BlockPos blockpos2 = start.m_6630_(layer);
            if (!this.replace.matches(world, blockpos2)) continue;
            this.placeLog(world, start.m_6630_(layer), logs);
        }
    }

    protected void generateHanging(LevelAccessor world, BlockPos start, Random rand, int height) {
        int y = start.m_123342_() + (height - this.leafLayers);
        for (int x = start.m_123341_() - (this.maxLeavesRadius + 1); x <= start.m_123341_() + (this.maxLeavesRadius + 1); ++x) {
            for (int z = start.m_123343_() - (this.maxLeavesRadius + 1); z <= start.m_123343_() + (this.maxLeavesRadius + 1); ++z) {
                BlockPos hangingPos = new BlockPos(x, y, z);
                if (world.m_46859_(hangingPos.m_7494_()) || !world.m_46859_(hangingPos) || !(rand.nextFloat() <= this.hangingChance)) continue;
                this.setHanging(world, hangingPos);
            }
        }
    }

    private void generateTrunkFruit(LevelAccessor world, int age, BlockPos pos, Direction direction) {
        if (this.trunkFruit == Blocks.f_50262_.m_49966_()) {
            this.m_5974_((LevelWriter)world, pos, (BlockState)((BlockState)this.trunkFruit.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        } else {
            this.m_5974_((LevelWriter)world, pos, (BlockState)this.trunkFruit.m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        }
    }

    private BlockState getVineStateForSide(Direction side) {
        return this.vine.m_60734_() instanceof VineBlock ? (BlockState)this.vine.m_61124_((Property)VineBlock.m_57883_((Direction)side), (Comparable)Boolean.valueOf(true)) : this.vine;
    }

    private void extendVines(LevelAccessor world, BlockPos pos, Direction side) {
        BlockState vineState = this.getVineStateForSide(side);
        this.m_5974_((LevelWriter)world, pos, vineState);
        pos = pos.m_7495_();
        for (int length = 4; this.placeVinesOn.matches(world, pos) && length > 0; --length) {
            this.m_5974_((LevelWriter)world, pos, vineState);
            pos = pos.m_7495_();
        }
    }

    protected static abstract class InnerBuilder<T extends TreeFeatureBase.BuilderBase, F extends TreeFeatureBase>
    extends TreeFeatureBase.BuilderBase<T, F> {
        protected int leafLayers;
        protected int leavesOffset;
        protected int maxLeavesRadius;
        protected int leavesLayerHeight;
        protected IBlockPosQuery placeVinesOn;
        protected float hangingChance;

        public T leafLayers(int a) {
            this.leafLayers = a;
            return (T)this;
        }

        public T leavesOffset(int a) {
            this.leavesOffset = a;
            return (T)this;
        }

        public T leavesLayerHeight(int a) {
            this.leavesLayerHeight = a;
            return (T)this;
        }

        public T maxLeavesRadius(int a) {
            this.maxLeavesRadius = a;
            return (T)this;
        }

        public T placeVinesOn(IBlockPosQuery a) {
            this.placeVinesOn = a;
            return (T)this;
        }

        public T hangingChance(float a) {
            this.hangingChance = a;
            return (T)this;
        }

        public InnerBuilder() {
            this.placeOn = (world, pos) -> world.m_8055_(pos).m_60815_();
            this.minHeight = 4;
            this.maxHeight = 7;
            this.leafLayers = 4;
            this.leavesOffset = 1;
            this.maxLeavesRadius = 1;
            this.leavesLayerHeight = 2;
            this.placeVinesOn = (world, pos) -> {
                Material mat = world.m_8055_(pos).m_60767_();
                return mat == Material.f_76296_;
            };
            this.hangingChance = 0.0f;
        }
    }

    public static class Builder
    extends InnerBuilder<Builder, BasicTreeFeature> {
        @Override
        public BasicTreeFeature create() {
            return new BasicTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.leafLayers, this.leavesOffset, this.maxLeavesRadius, this.leavesLayerHeight, this.placeVinesOn, this.hangingChance);
        }
    }
}

