/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BigTreeFeature
extends TreeFeatureBase {
    private double trunkHeightScale = 0.618;
    private double branchSlope = 0.381;
    private double widthScale = 1.0;
    private int trunkWidth = 1;
    private int foliageHeight;
    private double foliageDensity;

    protected BigTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth, int foliageHeight, double foliageDensity) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.foliageHeight = foliageHeight;
        this.foliageDensity = foliageDensity;
        this.trunkWidth = trunkWidth;
    }

    private void crossSection(LevelAccessor world, BlockPos pos, float radius, Random random, BiConsumer<BlockPos, BlockState> leaves) {
        int r = (int)((double)radius + this.trunkHeightScale);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius)) || !this.replace.matches(world, blockpos = pos.m_142082_(dx, 0, dz))) continue;
                if (this.altLeaves != Blocks.f_50016_.m_49966_()) {
                    int rand = random.nextInt(4);
                    if (rand == 0) {
                        this.placeAltLeaves(world, blockpos, leaves);
                        continue;
                    }
                    this.placeLeaves(world, blockpos, leaves);
                    continue;
                }
                this.placeLeaves(world, blockpos, leaves);
            }
        }
    }

    private float treeShape(int height, int y) {
        if ((float)y < (float)height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = Mth.m_14116_((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    private float foliageShape(int y) {
        if (y < 0 || y >= this.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == this.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(LevelAccessor world, BlockPos pos, Random random, BiConsumer<BlockPos, BlockState> leaves) {
        for (int y = 0; y < this.foliageHeight; ++y) {
            this.crossSection(world, pos.m_6630_(y), this.foliageShape(y), random, leaves);
        }
    }

    private int checkLineAndOptionallySet(LevelAccessor world, BlockPos startPos, BlockPos endPos, boolean set, BiConsumer<BlockPos, BlockState> logs) {
        if (!set && Objects.equals(startPos, endPos)) {
            return -1;
        }
        BlockPos delta = endPos.m_142082_(-startPos.m_123341_(), -startPos.m_123342_(), -startPos.m_123343_());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.m_123341_() / (float)steps;
        float dy = (float)delta.m_123342_() / (float)steps;
        float dz = (float)delta.m_123343_() / (float)steps;
        for (int j = 0; j <= steps; ++j) {
            BlockPos deltaPos = startPos.m_142022_((double)(0.5f + (float)j * dx), (double)(0.5f + (float)j * dy), (double)(0.5f + (float)j * dz));
            if (set) {
                this.placeLog(world, deltaPos, this.getLogAxis(startPos, deltaPos), logs);
                continue;
            }
            if (BigTreeFeature.m_67262_((LevelSimulatedReader)world, (BlockPos)deltaPos)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = Mth.m_14040_((int)posIn.m_123341_());
        int j = Mth.m_14040_((int)posIn.m_123342_());
        int k = Mth.m_14040_((int)posIn.m_123343_());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private Direction.Axis getLogAxis(BlockPos startPos, BlockPos endPos) {
        int zDiff;
        Direction.Axis axis = Direction.Axis.Y;
        int xDiff = Math.abs(endPos.m_123341_() - startPos.m_123341_());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.m_123343_() - startPos.m_123343_()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = Direction.Axis.X;
            } else if (zDiff == maxDiff) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }

    private void makeFoliage(LevelAccessor worldIn, int height, BlockPos pos, List<FoliageCoordinates> coordinates, Random random, BiConsumer<BlockPos, BlockState> leaves) {
        for (FoliageCoordinates coordinate : coordinates) {
            if (!this.trimBranches(height, coordinate.getBranchBase() - pos.m_123342_())) continue;
            this.foliageCluster(worldIn, coordinate, random, leaves);
        }
    }

    private boolean trimBranches(int height, int localY) {
        return (double)localY >= (double)height * 0.2;
    }

    private void makeTrunk(LevelAccessor world, BlockPos pos, int height, BiConsumer<BlockPos, BlockState> logs) {
        this.checkLineAndOptionallySet(world, pos, pos.m_6630_(height), true, logs);
        if (this.trunkWidth == 2) {
            this.checkLineAndOptionallySet(world, pos.m_142126_(), pos.m_6630_(height).m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142126_().m_142128_(), pos.m_6630_(height).m_142126_().m_142128_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142128_(), pos.m_6630_(height).m_142128_(), true, logs);
        }
        if (this.trunkWidth == 4) {
            this.checkLineAndOptionallySet(world, pos.m_142126_(), pos.m_6630_(height).m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142126_().m_142128_(), pos.m_6630_(height).m_142126_().m_142128_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142128_(), pos.m_6630_(height).m_142128_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142127_(), pos.m_6630_(height).m_142127_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142127_().m_142126_(), pos.m_6630_(height).m_142127_().m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142126_().m_142126_(), pos.m_6630_(height).m_142126_().m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142128_().m_142126_().m_142126_(), pos.m_6630_(height).m_142128_().m_142126_().m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142128_().m_142128_().m_142126_(), pos.m_6630_(height).m_142128_().m_142128_().m_142126_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142128_().m_142128_(), pos.m_6630_(height).m_142128_().m_142128_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142125_().m_142128_(), pos.m_6630_(height).m_142125_().m_142128_(), true, logs);
            this.checkLineAndOptionallySet(world, pos.m_142125_(), pos.m_6630_(height).m_142125_(), true, logs);
        }
    }

    private void makeBranches(LevelAccessor world, int height, BlockPos origin, List<FoliageCoordinates> coordinates, BiConsumer<BlockPos, BlockState> logs) {
        for (FoliageCoordinates coordinate : coordinates) {
            int branchBase = coordinate.getBranchBase();
            BlockPos baseCoord = new BlockPos(origin.m_123341_(), branchBase, origin.m_123343_());
            if (baseCoord.equals((Object)coordinate) || !this.trimBranches(height, branchBase - origin.m_123342_())) continue;
            this.checkLineAndOptionallySet(world, baseCoord, coordinate, true, logs);
        }
    }

    @Override
    protected boolean place(LevelAccessor world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int relativeY;
        int clustersPerY;
        Random random = new Random(rand.nextLong());
        int height = this.checkLocation(world, pos, this.minHeight + random.nextInt(this.maxHeight), logs);
        if (height == -1) {
            return false;
        }
        this.m_5974_((LevelWriter)world, pos.m_7495_(), Blocks.f_50493_.m_49966_());
        int trunkHeight = (int)((double)height * this.trunkHeightScale);
        if (trunkHeight >= height) {
            trunkHeight = height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(this.foliageDensity * (double)height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = pos.m_123342_() + trunkHeight;
        ArrayList foliageCoords = Lists.newArrayList();
        foliageCoords.add(new FoliageCoordinates(pos.m_6630_(relativeY), trunkTop));
        for (relativeY = height - this.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(height, relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                BlockPos checkEnd;
                double z;
                double angle;
                double radius = 1.0 * (double)treeShape * ((double)random.nextFloat() + 0.328);
                double x = radius * Math.sin(angle = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos checkStart = pos.m_142022_(x, (double)(relativeY - 1), z = radius * Math.cos(angle) + 0.5);
                if (this.checkLineAndOptionallySet(world, checkStart, checkEnd = checkStart.m_6630_(5), false, logs) != -1) continue;
                int dx = pos.m_123341_() - checkStart.m_123341_();
                int dz = pos.m_123343_() - checkStart.m_123343_();
                double branchHeight = (double)checkStart.m_123342_() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = branchHeight > (double)trunkTop ? trunkTop : (int)branchHeight;
                BlockPos checkBranchBase = new BlockPos(pos.m_123341_(), branchTop, pos.m_123343_());
                if (this.checkLineAndOptionallySet(world, checkBranchBase, checkStart, false, logs) != -1) continue;
                foliageCoords.add(new FoliageCoordinates(checkStart, checkBranchBase.m_123342_()));
            }
        }
        this.makeFoliage(world, height, pos, foliageCoords, random, leaves);
        this.makeTrunk(world, pos, trunkHeight, logs);
        this.makeBranches(world, height, pos, foliageCoords, logs);
        return true;
    }

    private int checkLocation(LevelAccessor world, BlockPos pos, int height, BiConsumer<BlockPos, BlockState> logs) {
        if (!this.placeOn.matches(world, pos.m_7495_())) {
            return -1;
        }
        int step = this.checkLineAndOptionallySet(world, pos, pos.m_6630_(height - 1), false, logs);
        if (step == -1) {
            return height;
        }
        return step < 6 ? -1 : step;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BigTreeFeature> {
        private int trunkWidth;
        private int foliageHeight;
        private double foliageDensity;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder foliageHeight(int a) {
            this.foliageHeight = a;
            return this;
        }

        public Builder foliageDensity(int a) {
            this.foliageDensity = a;
            return this;
        }

        public Builder() {
            this.minHeight = 5;
            this.maxHeight = 12;
            this.trunkWidth = 1;
            this.foliageHeight = 5;
            this.foliageDensity = 1.0;
        }

        @Override
        public BigTreeFeature create() {
            return new BigTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth, this.foliageHeight, this.foliageDensity);
        }
    }
}

