/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class BulbTreeFeature
extends TreeFeatureBase {
    protected BulbTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    public boolean setCocoa(LevelAccessor world, BlockPos pos, Direction side) {
        BlockState cocoaState = (BlockState)Blocks.f_50262_.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)side);
        if (this.replace.matches(world, pos)) {
            this.m_5974_((LevelWriter)world, pos, cocoaState);
            return true;
        }
        return false;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_142082_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateBranch(LevelAccessor world, Random random, BlockPos pos, Direction direction, BiConsumer<BlockPos, BlockState> leaves) {
        Direction sideways = direction.m_122427_();
        this.placeLeaves(world, pos.m_5484_(direction, 1), leaves);
        this.placeLeaves(world, pos.m_7494_().m_5484_(direction, 1), leaves);
        if (random.nextInt(3) > 0) {
            this.placeLeaves(world, pos.m_7494_().m_5484_(direction, 1).m_5484_(sideways, 1), leaves);
        }
    }

    public void generateLeafLayer(LevelAccessor world, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.generateBranch(world, random, pos, direction, leaves);
        }
        this.placeLog(world, pos, logs);
        this.placeLog(world, pos.m_7494_(), logs);
    }

    public void generateTop(LevelAccessor world, Random random, BlockPos pos, int topHeight, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        for (int y = 0; y < topHeight; ++y) {
            int radius = topHeight - 1 - y;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) >= radius && Math.abs(z) >= radius && random.nextInt(2) != 0) continue;
                    this.placeLeaves(world, pos.m_142082_(x, y, z), leaves);
                }
            }
            if (y < topHeight - 1) {
                this.placeLog(world, pos.m_142082_(0, y, 0), logs);
                continue;
            }
            this.placeLeaves(world, pos.m_142082_(0, y, 0), leaves);
        }
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int i;
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 6) {
            return false;
        }
        int topHeight = 3;
        int heightMinusTop = height - topHeight;
        int numBranches = heightMinusTop / 5;
        int baseHeight = heightMinusTop - numBranches * 2;
        BlockPos pos = startPos.m_7494_();
        if (!this.checkSpace(world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.placeLog(world, pos, logs);
            pos = pos.m_7494_();
        }
        for (i = 0; i < numBranches; ++i) {
            this.generateLeafLayer(world, random, pos, logs, leaves);
            pos = pos.m_6630_(2);
        }
        this.generateTop(world, random, pos, topHeight, logs, leaves);
        this.addVines(world, random, startPos, baseHeight, height, 3, 10);
        return true;
    }

    protected void addVines(LevelAccessor world, Random rand, BlockPos startPos, int baseHeight, int height, int leavesRadius, int generationAttempts) {
        if (this.vine == null) {
            return;
        }
        block0: for (int i = 0; i < generationAttempts; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.m_122560_(rand);
            Direction back = direction.m_122424_();
            Direction sideways = direction.m_122427_();
            BlockPos pos = startPos.m_6630_(GeneratorUtil.nextIntBetween(rand, baseHeight + 1, height)).m_5484_(direction, leavesRadius + 1).m_5484_(sideways, GeneratorUtil.nextIntBetween(rand, -leavesRadius, leavesRadius));
            for (int l = 0; l < leavesRadius; ++l) {
                if (world.m_8055_(pos.m_5484_(back, 1 + l)) != this.leaves) continue;
                this.setVine(world, rand, pos.m_5484_(back, l), back, 4);
                continue block0;
            }
        }
    }

    protected void addCocoa(LevelAccessor world, Random rand, BlockPos startPos, int baseHeight, int generationAttempts) {
        for (int i = 0; i < generationAttempts; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.m_122560_(rand);
            Direction back = direction.m_122424_();
            BlockPos pos = startPos.m_6630_(GeneratorUtil.nextIntBetween(rand, 1, baseHeight)).m_5484_(direction, 1);
            this.setCocoa(world, pos, back);
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BulbTreeFeature> {
        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 12;
        }

        @Override
        public BulbTreeFeature create() {
            return new BulbTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

