/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class BushTreeFeature
extends TreeFeatureBase {
    protected BushTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        while (startPos.m_123342_() > 1 && (world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76296_)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        BlockPos pos = startPos.m_7494_();
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.placeLog(world, pos.m_142082_(0, y, 0), logs);
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.nextInt(2) == 0) continue;
                    if (this.altLeaves != Blocks.f_50016_.m_49966_()) {
                        if (random.nextInt(4) == 0) {
                            this.placeAltLeaves(world, pos.m_142082_(x, y, z), leaves);
                            continue;
                        }
                        this.placeLeaves(world, pos.m_142082_(x, y, z), leaves);
                        continue;
                    }
                    this.placeLeaves(world, pos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, BushTreeFeature> {
        public Builder() {
            this.minHeight = 2;
            this.maxHeight = 2;
        }

        @Override
        public BushTreeFeature create() {
            if (this.leaves != Blocks.f_50016_.m_49966_()) {
                this.leaves = this.leaves;
            }
            if (this.altLeaves != Blocks.f_50016_.m_49966_()) {
                this.altLeaves = this.altLeaves;
            }
            return new BushTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

