/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.BOPFeatureUtil;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.material.Material;

public class CypressTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected CypressTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = this.trunkWidth - 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_142082_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        BlockPos pos2 = pos.m_142082_(0, height - 2, 0);
        return TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos2);
    }

    public void generateLeafLayer(LevelAccessor world, Random rand, BlockPos pos, int leavesRadius, BiConsumer<BlockPos, BlockState> leaves) {
        int start = -leavesRadius;
        int end = leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || leavesRadius > 0 && (x == start || x == end || z == start || z == end) && rand.nextDouble() < 0.2) continue;
                this.placeLeaves(world, pos.m_142082_(x, 0, z), leaves);
            }
        }
    }

    public void generateBranch(LevelAccessor world, Random rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        Direction.Axis axis = direction.m_122434_();
        Direction sideways = direction.m_122427_();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.m_5484_(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.m_5484_(sideways, j), leaves);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.m_7494_(), leaves);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, -1), leaves);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, 1), leaves);
            this.placeLog(world, pos1, axis, logs);
        }
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int leavesHeight;
        while (startPos.m_123342_() > 1 && this.replace.matches(world, startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        for (int x = 0; x <= this.trunkWidth - 1; ++x) {
            for (int z = 0; z <= this.trunkWidth - 1; ++z) {
                if (this.placeOn.matches(world, startPos.m_142082_(x, 0, z))) continue;
                return false;
            }
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f));
        int baseLeavesHeight = leavesHeight = height - baseHeight;
        if (leavesHeight < 3) {
            return false;
        }
        leavesHeight = Mth.m_14045_((int)leavesHeight, (int)3, (int)5);
        leavesHeight = Mth.m_14045_((int)(leavesHeight + random.nextInt(3)), (int)0, (int)baseLeavesHeight);
        if (!this.checkSpace(world, startPos.m_7494_(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.m_6630_(height);
        this.placeLeaves(world, pos, leaves);
        pos.m_7495_();
        for (int i = 0; i < leavesHeight; ++i) {
            int radius = 3;
            if (i == 0) {
                radius = 1;
            } else if (i <= 2) {
                radius = 2;
            }
            this.generateLeafLayer(world, random, pos, radius, leaves);
            pos = pos.m_7495_();
        }
        this.placeSpanishMoss(world, random, pos);
        int trunkRadius = this.trunkWidth - 1;
        for (int x = -trunkRadius; x <= trunkRadius; ++x) {
            for (int z = -trunkRadius; z <= trunkRadius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist > trunkRadius) continue;
                int heightHere = height - 1;
                if (dist == 1) {
                    heightHere = (int)((double)height * (0.2 + random.nextDouble() * 0.15));
                }
                heightHere += random.nextInt(2);
                for (int y = 0; y < heightHere; ++y) {
                    BlockPos local = startPos.m_142082_(x, y, z);
                    boolean air = world.m_8055_(local).m_60819_().m_76178_();
                    this.placeLog(world, local, logs);
                    if (x != 0 || z != 0 || !air || y >= heightHere - leavesHeight + 1) continue;
                    if (y >= baseHeight && random.nextInt(3) == 0) {
                        double theta = Math.PI * random.nextDouble() * 2.0;
                        int length = 2 + random.nextInt(3);
                        BlockPos branchPos = null;
                        for (int i = 0; i < length; ++i) {
                            branchPos = local.m_142022_(Math.cos(theta) * (double)i, (double)(i / 2), Math.sin(theta) * (double)i);
                            this.placeLog(world, branchPos, logs);
                        }
                        this.generateLeafLayer(world, random, branchPos, 2, leaves);
                        this.generateLeafLayer(world, random, branchPos.m_7494_(), 1, leaves);
                        if (random.nextBoolean()) {
                            this.generateLeafLayer(world, random, branchPos.m_6630_(2), 0, leaves);
                        }
                        this.placeSpanishMoss(world, random, branchPos);
                        continue;
                    }
                    if (y < baseHeight || random.nextInt(3) != 0) continue;
                    Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
                    BlockPos offset = local.m_142300_(direction);
                    this.placeLog(world, offset, logs);
                    for (Direction dir : Direction.values()) {
                        if (!(random.nextDouble() > 0.2)) continue;
                        this.placeLeaves(world, offset.m_142300_(dir), leaves);
                    }
                    this.placeSpanishMoss(world, random, offset);
                }
            }
        }
        return true;
    }

    @Override
    public boolean placeLeaves(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> leaves) {
        if (TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos)) {
            leaves.accept(pos, this.leaves);
            return true;
        }
        return false;
    }

    private void placeSpanishMoss(LevelAccessor p_236429_1_, Random p_236429_2_, BlockPos p_236429_3_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 50; ++i) {
            BlockState blockstate;
            blockpos$mutable.m_122154_((Vec3i)p_236429_3_, p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5), p_236429_2_.nextInt(3) - p_236429_2_.nextInt(3), p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5));
            if (!p_236429_1_.m_46859_((BlockPos)blockpos$mutable) || (blockstate = p_236429_1_.m_8055_(blockpos$mutable.m_7494_())).m_60734_() != BOPBlocks.WILLOW_LEAVES) continue;
            int j = Mth.m_14072_((Random)p_236429_2_, (int)1, (int)3);
            if (p_236429_2_.nextInt(5) == 0) {
                j = 1;
            }
            CypressTreeFeature.placeSpanishMossColumn(p_236429_1_, p_236429_2_, blockpos$mutable, j, 17, 25);
        }
    }

    public static void placeSpanishMossColumn(LevelAccessor p_236427_0_, Random p_236427_1_, BlockPos.MutableBlockPos p_236427_2_, int p_236427_3_, int p_236427_4_, int p_236427_5_) {
        for (int i = 0; i <= p_236427_3_; ++i) {
            if (p_236427_0_.m_46859_((BlockPos)p_236427_2_)) {
                if (i == p_236427_3_ || !p_236427_0_.m_46859_(p_236427_2_.m_7495_())) {
                    p_236427_0_.m_7731_((BlockPos)p_236427_2_, (BlockState)BOPBlocks.SPANISH_MOSS.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)p_236427_1_, (int)p_236427_4_, (int)p_236427_5_))), 2);
                    break;
                }
                p_236427_0_.m_7731_((BlockPos)p_236427_2_, BOPBlocks.SPANISH_MOSS_PLANT.m_49966_(), 2);
            }
            p_236427_2_.m_122173_(Direction.DOWN);
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, CypressTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 15;
            this.placeOn = BOPFeatureUtil::isSoil;
            this.replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60767_() == Material.f_76305_ || world.m_8055_(pos).m_60620_((Tag)BlockTags.f_13104_) || world.m_8055_(pos).m_60734_() == Blocks.f_50191_ || world.m_8055_(pos).m_60734_() == BOPBlocks.WILLOW_VINE || world.m_8055_(pos).m_60734_() == BOPBlocks.SPANISH_MOSS_PLANT || world.m_8055_(pos).m_60734_() == BOPBlocks.SPANISH_MOSS || world.m_8055_(pos).m_60734_() instanceof BushBlock;
            this.log = BOPBlocks.WILLOW_LOG.m_49966_();
            this.leaves = BOPBlocks.WILLOW_LEAVES.m_49966_();
            this.vine = BOPBlocks.WILLOW_VINE.m_49966_();
            this.trunkWidth = 1;
        }

        @Override
        public CypressTreeFeature create() {
            return new CypressTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

