/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.BOPFeatureUtil;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MahoganyTreeFeature
extends TreeFeatureBase {
    protected MahoganyTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= 1 && pos.m_123342_() + height + 1 <= 256) {
            for (int y = pos.m_123342_(); y <= pos.m_123342_() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.m_123342_()) {
                    radius = 0;
                }
                if (y >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius && hasSpace; ++x) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            boolean isSoil = BOPFeatureUtil.isSoil((LevelReader)world, soilPos);
            if (this.placeOn.matches(world, soilPos) && isSoil && pos.m_123342_() < 256 - height - 1) {
                world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
                this.generateTrunk(logs, leaves, world, pos, height);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, LevelAccessor world, BlockPos start, int height) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.m_6630_(layer);
            if (!this.replace.matches(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs);
        }
        BlockPos branchStartPos = start.m_6630_(endHeight - 3);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.NORTH);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.EAST);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.SOUTH);
        this.generateBranch(logs, leaves, world, branchStartPos, Direction.WEST);
    }

    private void generateBranch(BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, LevelAccessor world, BlockPos middle, Direction direction) {
        int z;
        int x;
        BlockPos pos = middle;
        int length = 1 + world.m_5822_().nextInt(2);
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.replace.matches(world, pos.m_5484_(direction, i + 1))) continue;
            this.placeLog(world, pos.m_5484_(direction, i + 1), direction.m_122434_(), logs);
        }
        int height = 1 + world.m_5822_().nextInt(2);
        for (int i = 0; i <= height; ++i) {
            if (!this.replace.matches(world, pos.m_5484_(direction, length + 1).m_6630_(i + 1))) continue;
            this.placeLog(world, pos.m_5484_(direction, length + 1).m_6630_(i + 1), Direction.Axis.Y, logs);
        }
        pos = pos.m_5484_(direction, length + 1).m_6630_(height + 2);
        int radius = 2;
        for (x = -(radius - 1); x <= radius - 1; ++x) {
            for (z = -(radius - 1); z <= radius - 1; ++z) {
                this.placeLeaves(world, pos.m_142082_(x, 0, z), leaves);
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                if (!(x != -radius && x != radius || z != -radius && z != radius)) continue;
                this.placeLeaves(world, pos.m_142082_(x, -1, z), leaves);
            }
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, MahoganyTreeFeature> {
        public Builder() {
            this.log = BOPBlocks.MAHOGANY_LOG.m_49966_();
            this.leaves = BOPBlocks.MAHOGANY_LEAVES.m_49966_();
            this.minHeight = 8;
            this.maxHeight = 14;
        }

        @Override
        public MahoganyTreeFeature create() {
            return new MahoganyTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

