/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.BOPFeatureUtil;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class PalmTreeFeature
extends TreeFeatureBase {
    protected PalmTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = false;
        Direction direction = Direction.m_122404_((Random)random);
        if (direction == Direction.DOWN || direction == Direction.UP) {
            slant = false;
        }
        double baseSlant = (double)random.nextInt(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.m_6630_(step);
            if (slant) {
                offsetPos = pos.m_6630_(step).m_5484_(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.placeLog(world, offsetPos, logs);
                this.generateLeavesTop(world, offsetPos, leavesRadius, leaves);
                break;
            }
            this.placeLog(world, offsetPos, logs);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_142082_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(LevelAccessor world, BlockPos pos, int maxRadius, BiConsumer<BlockPos, BlockState> leaves) {
        this.placeLeaves(world, pos.m_142082_(2, -1, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(-2, -1, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(0, -1, 2), leaves);
        this.placeLeaves(world, pos.m_142082_(0, -1, -2), leaves);
        this.placeLeaves(world, pos.m_142082_(1, 0, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(-1, 0, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(0, 0, 1), leaves);
        this.placeLeaves(world, pos.m_142082_(0, 0, -1), leaves);
        this.placeLeaves(world, pos.m_142082_(2, 0, 2), leaves);
        this.placeLeaves(world, pos.m_142082_(-2, 0, -2), leaves);
        this.placeLeaves(world, pos.m_142082_(2, 0, -2), leaves);
        this.placeLeaves(world, pos.m_142082_(-2, 0, 2), leaves);
        this.placeLeaves(world, pos.m_142082_(1, 1, -1), leaves);
        this.placeLeaves(world, pos.m_142082_(-1, 1, 1), leaves);
        this.placeLeaves(world, pos.m_142082_(1, 1, 1), leaves);
        this.placeLeaves(world, pos.m_142082_(-1, 1, -1), leaves);
        this.placeLeaves(world, pos.m_142082_(0, 1, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(2, 2, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(-2, 2, 0), leaves);
        this.placeLeaves(world, pos.m_142082_(0, 2, 2), leaves);
        this.placeLeaves(world, pos.m_142082_(0, 2, -2), leaves);
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, PalmTreeFeature> {
        public Builder() {
            this.placeOn = (world, pos) -> {
                Block ground = world.m_8055_(pos).m_60734_();
                return BOPFeatureUtil.isSoil((LevelReader)world, pos) || ground == BOPBlocks.WHITE_SAND || ground == Blocks.f_49993_ || ground == Blocks.f_49992_;
            };
            this.minHeight = 10;
            this.maxHeight = 14;
            this.log = BOPBlocks.PALM_LOG.m_49966_();
            this.leaves = (BlockState)BOPBlocks.PALM_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        }

        @Override
        public PalmTreeFeature create() {
            return new PalmTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

