/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class RedwoodTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected RedwoodTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = this.trunkWidth * (height - y) / height + 1;
            int trunkStart = Mth.m_14165_((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.m_14107_((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.m_142082_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, Random rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, BiConsumer<BlockPos, BlockState> leaves) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.nextInt(2) != 0)) continue;
                this.placeLeaves(world, pos.m_142082_(x, 0, z), leaves);
            }
        }
    }

    public void generateBranch(LevelAccessor world, Random rand, BlockPos pos, Direction direction, int length, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        Direction.Axis axis = direction.m_122434_();
        Direction sideways = direction.m_122427_();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.m_5484_(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.m_5484_(sideways, j), leaves);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.m_7494_(), leaves);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, -1), leaves);
            this.placeLeaves(world, pos1.m_7494_().m_5484_(sideways, 1), leaves);
            this.placeLog(world, pos1, axis, logs);
        }
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int baseHeight;
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        for (int x = 0; x <= this.trunkWidth - 1; ++x) {
            for (int z = 0; z <= this.trunkWidth - 1; ++z) {
                if (this.placeOn.matches(world, startPos.m_142082_(x, 0, z))) continue;
                return false;
            }
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace(world, startPos.m_7494_(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.m_6630_(height);
        this.placeLeaves(world, pos, leaves);
        pos.m_7495_();
        for (int i = 0; i < leavesHeight; ++i) {
            int trunkWidth = this.trunkWidth * i / height + 1;
            int trunkStart = Mth.m_14165_((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = Mth.m_14107_((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 4, 2 + (leavesHeight - i)), 4);
            if (radius == 0) {
                this.placeLeaves(world, pos, leaves);
            } else if (radius < 2) {
                this.generateLeafLayer(world, random, pos, radius, trunkStart, trunkEnd, leaves);
            } else {
                this.generateBranch(world, random, pos.m_142082_(trunkStart, 0, trunkStart), Direction.NORTH, radius, logs, leaves);
                this.generateBranch(world, random, pos.m_142082_(trunkEnd, 0, trunkStart), Direction.EAST, radius, logs, leaves);
                this.generateBranch(world, random, pos.m_142082_(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, logs, leaves);
                this.generateBranch(world, random, pos.m_142082_(trunkStart, 0, trunkEnd), Direction.WEST, radius, logs, leaves);
            }
            pos = pos.m_7495_();
        }
        double[] scalingFactors = new double[]{0.35 + random.nextDouble() * 0.15, 0.07 + random.nextDouble() * 0.1, random.nextDouble() * 0.06};
        if (this.trunkWidth == 3) {
            scalingFactors = new double[]{0.6 + random.nextDouble() * 0.2, 0.1 + random.nextDouble() * 0.2, 0.03 + random.nextDouble() * 0.09};
        }
        for (int x = -this.trunkWidth; x <= this.trunkWidth; ++x) {
            for (int z = -this.trunkWidth; z <= this.trunkWidth; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                int heightHere = height - 2;
                if (this.trunkWidth == 1 && dist > 0) continue;
                if (dist == 1) {
                    heightHere = (int)((double)height * scalingFactors[0]);
                } else if (dist == 2) {
                    heightHere = (int)((double)height * scalingFactors[1]);
                } else if (dist == 3) {
                    heightHere = (int)((double)height * scalingFactors[2]);
                } else if (dist > 3) continue;
                heightHere += random.nextInt(2);
                for (int y = 0; y < heightHere; ++y) {
                    double theta;
                    BlockPos local = startPos.m_142082_(x, y, z);
                    this.placeLog(world, local, logs);
                    if (dist <= 0 || y <= 4 || y >= baseHeight - 2 || random.nextInt(10) != 0) continue;
                    if (x == 0 && z == 0) {
                        if (y < 10) continue;
                        theta = Math.PI * random.nextDouble() * 2.0;
                    } else {
                        double angleFromCenter = Math.atan2(x, z);
                        theta = angleFromCenter + Math.PI * (random.nextDouble() * 0.5 - 0.25);
                    }
                    int branchLength = 3 - dist + 1 + random.nextInt(2);
                    BlockPos branchPos = null;
                    for (int i = 0; i < branchLength; ++i) {
                        branchPos = local.m_142022_(Math.cos(theta) * (double)i, (double)(i / 2), Math.sin(theta) * (double)i);
                        this.placeLog(world, branchPos, logs);
                    }
                    this.generateBush(logs, leaves, world, random, branchPos);
                }
            }
        }
        return true;
    }

    protected boolean generateBush(BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, LevelAccessor world, Random random, BlockPos pos) {
        for (int y = -1; y < 2; ++y) {
            if (y == 0) {
                this.placeLog(world, pos.m_142082_(0, y, 0), logs);
            }
            int leavesRadius = y == 0 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.nextInt(2) == 0) continue;
                    if (this.altLeaves != Blocks.f_50016_.m_49966_()) {
                        if (random.nextInt(4) == 0) {
                            this.placeAltLeaves(world, pos.m_142082_(x, y, z), leaves);
                            continue;
                        }
                        this.placeLeaves(world, pos.m_142082_(x, y, z), leaves);
                        continue;
                    }
                    this.placeLeaves(world, pos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, RedwoodTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 10;
            this.maxHeight = 30;
            this.log = BOPBlocks.REDWOOD_LOG.m_49966_();
            this.leaves = BOPBlocks.REDWOOD_LEAVES.m_49966_();
            this.vine = Blocks.f_50191_.m_49966_();
            this.trunkWidth = 1;
        }

        @Override
        public RedwoodTreeFeature create() {
            return new RedwoodTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

