/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.BlockUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.BOPFeatureUtil;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public abstract class TreeFeatureBase
extends TreeFeature {
    protected final IBlockPosQuery placeOn;
    protected final IBlockPosQuery replace;
    protected final BlockState log;
    protected final BlockState leaves;
    protected final BlockState altLeaves;
    protected final BlockState vine;
    protected final BlockState hanging;
    protected final BlockState trunkFruit;
    protected final int minHeight;
    protected final int maxHeight;
    protected Property logAxisProperty;

    protected TreeFeatureBase(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(TreeConfiguration.f_68184_.stable());
        this.placeOn = placeOn;
        this.replace = replace;
        this.log = log;
        this.leaves = leaves;
        this.logAxisProperty = BlockUtil.getAxisProperty(log);
        this.altLeaves = altLeaves;
        this.vine = vine;
        this.hanging = hanging;
        this.trunkFruit = trunkFruit;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public boolean placeLeaves(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> leaves) {
        if (this.replace.matches(world, pos)) {
            leaves.accept(pos, this.leaves);
            return true;
        }
        return false;
    }

    public boolean placeAltLeaves(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> leaves) {
        if (this.replace.matches(world, pos)) {
            leaves.accept(pos, this.altLeaves);
            return true;
        }
        return false;
    }

    public boolean placeLog(LevelAccessor world, BlockPos pos, BiConsumer<BlockPos, BlockState> logs) {
        return this.placeLog(world, pos, null, logs);
    }

    public boolean placeLog(LevelAccessor world, BlockPos pos, Direction.Axis axis, BiConsumer<BlockPos, BlockState> logs) {
        BlockState directedLog;
        BlockState blockState = directedLog = axis != null && this.logAxisProperty != null ? (BlockState)this.log.m_61124_(this.logAxisProperty, (Comparable)axis) : this.log;
        if (this.replace.matches(world, pos)) {
            logs.accept(pos, directedLog);
            return true;
        }
        return false;
    }

    public boolean setVine(LevelAccessor world, Random rand, BlockPos pos, Direction side, int length) {
        BlockState vineState = this.vine.m_60734_() instanceof VineBlock ? (BlockState)((BlockState)((BlockState)((BlockState)this.vine.m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(side == Direction.NORTH))).m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(side == Direction.EAST))).m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(side == Direction.SOUTH))).m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(side == Direction.WEST)) : this.vine;
        boolean setOne = false;
        while (world.m_8055_(pos).m_60795_() && length > 0 && rand.nextInt(12) > 0) {
            this.m_5974_((LevelWriter)world, pos, vineState);
            setOne = true;
            --length;
            pos = pos.m_7495_();
        }
        return setOne;
    }

    public boolean setHanging(LevelAccessor world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            this.m_5974_((LevelWriter)world, pos, this.hanging);
        }
        return false;
    }

    public boolean setTrunkFruit(LevelAccessor world, BlockPos pos) {
        if (this.trunkFruit == null) {
            return false;
        }
        if (this.replace.matches(world, pos)) {
            this.m_5974_((LevelWriter)world, pos, this.trunkFruit);
        }
        return false;
    }

    public boolean m_160510_(WorldGenLevel reader, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves, TreeConfiguration config) {
        return this.place((LevelAccessor)reader, random, pos, logs, leaves);
    }

    protected boolean place(LevelAccessor world, Random rand, BlockPos position, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        return false;
    }

    protected static abstract class BuilderBase<T extends BuilderBase, F extends TreeFeatureBase> {
        protected IBlockPosQuery placeOn = BOPFeatureUtil::isSoil;
        protected IBlockPosQuery replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60620_((Tag)BlockTags.f_13104_) || world.m_8055_(pos).m_60734_() == Blocks.f_50191_ || world.m_8055_(pos).m_60734_() == BOPBlocks.WILLOW_VINE || world.m_8055_(pos).m_60734_() == BOPBlocks.DEAD_BRANCH || world.m_8055_(pos).m_60734_() == Blocks.f_152543_ || world.m_8055_(pos).m_60734_() instanceof BushBlock;
        protected BlockState log = Blocks.f_49999_.m_49966_();
        protected BlockState leaves = Blocks.f_50050_.m_49966_();
        protected BlockState vine = Blocks.f_50016_.m_49966_();
        protected BlockState hanging = Blocks.f_50016_.m_49966_();
        protected BlockState trunkFruit = Blocks.f_50016_.m_49966_();
        protected BlockState altLeaves = Blocks.f_50016_.m_49966_();
        protected int minHeight;
        protected int maxHeight;

        public T placeOn(IBlockPosQuery a) {
            this.placeOn = a;
            return (T)this;
        }

        public T replace(IBlockPosQuery a) {
            this.replace = a;
            return (T)this;
        }

        public T log(BlockState a) {
            this.log = a;
            return (T)this;
        }

        public T leaves(BlockState a) {
            this.leaves = a;
            return (T)this;
        }

        public T vine(BlockState a) {
            this.vine = a;
            return (T)this;
        }

        public T hanging(BlockState a) {
            this.hanging = a;
            return (T)this;
        }

        public T trunkFruit(BlockState a) {
            this.trunkFruit = a;
            return (T)this;
        }

        public T altLeaves(BlockState a) {
            this.altLeaves = a;
            return (T)this;
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return (T)this;
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return (T)this;
        }

        abstract F create();
    }
}

