/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class TwigletTreeFeature
extends TreeFeatureBase {
    private float leafChanceEven;
    private float leafChanceOdd;

    protected TwigletTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, float leafChanceEven, float leafChanceOdd) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.leafChanceEven = leafChanceEven;
        this.leafChanceOdd = leafChanceOdd;
    }

    @Override
    protected boolean place(LevelAccessor world, Random random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = this.minHeight + random.nextInt(1 + this.maxHeight - this.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.m_7494_();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.placeLog(world, pos.m_6630_(y), logs)) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? this.leafChanceEven : this.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.nextFloat() < leafChance) {
                this.placeLeaves(world, pos.m_142082_(1, y, 0), leaves);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves(world, pos.m_142082_(-1, y, 0), leaves);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves(world, pos.m_142082_(0, y, 1), leaves);
            }
            if (random.nextFloat() < leafChance) {
                this.placeLeaves(world, pos.m_142082_(0, y, -1), leaves);
            }
            if (this.trunkFruit == Blocks.f_50016_.m_49966_()) continue;
            for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                if (random.nextInt(4) != 0) continue;
                if (this.trunkFruit.m_60734_() == Blocks.f_50262_) {
                    this.generateTrunkFruit(world, random.nextInt(3), pos.m_142082_(Direction2.m_122424_().m_122429_(), 0, Direction2.m_122424_().m_122431_()), Direction2);
                    continue;
                }
                this.generateTrunkFruit(world, random.nextInt(3), pos.m_142082_(Direction2.m_122429_(), y, Direction2.m_122431_()), Direction2);
            }
        }
        this.placeLeaves(world, pos.m_142082_(0, height, 0), leaves);
        return true;
    }

    private void generateTrunkFruit(LevelAccessor world, int age, BlockPos pos, Direction direction) {
        if (this.trunkFruit == Blocks.f_50262_.m_49966_()) {
            if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
                this.m_5974_((LevelWriter)world, pos, (BlockState)((BlockState)this.trunkFruit.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
            }
        } else if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
            this.m_5974_((LevelWriter)world, pos, (BlockState)this.trunkFruit.m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, TwigletTreeFeature> {
        protected float leafChanceEven;
        protected float leafChanceOdd;

        public Builder leafChance(float a) {
            this.leafChanceEven = a;
            this.leafChanceOdd = a;
            return this;
        }

        public Builder leafChance(float a, float b) {
            this.leafChanceEven = a;
            this.leafChanceOdd = b;
            return this;
        }

        public Builder() {
            this.minHeight = 2;
            this.maxHeight = 6;
            this.leafChanceEven = 0.2f;
            this.leafChanceOdd = 0.9f;
        }

        @Override
        public TwigletTreeFeature create() {
            return new TwigletTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.leafChanceEven, this.leafChanceOdd);
        }
    }
}

