/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.surfacebuilders;

import biomesoplenty.common.world.AlphaOctavePerlinNoise;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderBaseConfiguration;

public class OriginValleySurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderBaseConfiguration> {
    protected long seed;
    protected AlphaOctavePerlinNoise sandNoise;
    protected AlphaOctavePerlinNoise gravelNoise;

    public OriginValleySurfaceBuilder(Codec<SurfaceBuilderBaseConfiguration> p_i232124_1_) {
        super(p_i232124_1_);
    }

    public void apply(Random random, ChunkAccess chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, int startY, long seed, SurfaceBuilderBaseConfiguration config) {
        this.apply(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.m_6743_(), config.m_6744_(), config.m_142434_(), seaLevel);
    }

    protected void apply(Random random, ChunkAccess chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        BlockState topState = top;
        BlockState middleState = middle;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int placedDepth = -1;
        int grassDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        boolean gravelGen = this.gravelNoise.sample(x, 109.0134, z, 0.03125, 1.0, 0.03125) + random.nextDouble() * 0.2 > 3.0;
        boolean sandGen = this.sandNoise.sample(x, z, 0.0, 0.03125, 0.03125, 1.0) + random.nextDouble() * 0.2 > 0.0;
        for (int y = startHeight; y >= 0; --y) {
            mutable.m_122178_(localX, y, localZ);
            BlockState blockstate2 = chunkIn.m_8055_((BlockPos)mutable);
            if (blockstate2.m_60795_()) {
                placedDepth = -1;
                continue;
            }
            if (!blockstate2.m_60713_(defaultBlock.m_60734_())) continue;
            if (placedDepth == -1) {
                if (grassDepth <= 0) {
                    topState = Blocks.f_50016_.m_49966_();
                    middleState = defaultBlock;
                } else if (y >= sealevel - 4 && y <= sealevel + 1) {
                    topState = top;
                    middleState = middle;
                    if (gravelGen) {
                        topState = Blocks.f_50016_.m_49966_();
                        middleState = Blocks.f_49994_.m_49966_();
                    }
                    if (sandGen) {
                        topState = Blocks.f_49992_.m_49966_();
                        middleState = Blocks.f_49992_.m_49966_();
                    }
                }
                if (y < sealevel && (topState == null || topState.m_60795_())) {
                    topState = biomeIn.m_47505_((BlockPos)mutable.m_122178_(x, y, z)) < 0.15f ? Blocks.f_50126_.m_49966_() : defaultFluid;
                    mutable.m_122178_(localX, y, localZ);
                }
                placedDepth = grassDepth;
                if (y >= sealevel - 1) {
                    chunkIn.m_6978_((BlockPos)mutable, topState, false);
                    continue;
                }
                chunkIn.m_6978_((BlockPos)mutable, middleState, false);
                continue;
            }
            if (placedDepth <= 0) continue;
            --placedDepth;
            chunkIn.m_6978_((BlockPos)mutable, middleState, false);
        }
    }

    public void m_6190_(long seed) {
        if (this.seed != seed || this.sandNoise == null || this.gravelNoise == null) {
            WorldgenRandom random = new WorldgenRandom(seed);
            this.sandNoise = new AlphaOctavePerlinNoise((Random)random, 4);
            this.gravelNoise = new AlphaOctavePerlinNoise((Random)random, 4);
        }
        this.seed = seed;
    }
}

