/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.util.biome.BiomeUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.Layers;
import net.minecraft.world.level.newbiome.layer.traits.CastleTransformer;

public enum BOPBiomeEdgeLayer implements CastleTransformer
{
    INSTANCE;

    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int SNOWY_TUNDRA;
    private static final int JUNGLE;
    private static final int JUNGLE_HILLS;
    private static final int JUNGLE_EDGE;
    private static final int BADLANDS;
    private static final int BADLANDS_PLATEAU;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int MOUNTAIN_EDGE;
    private static final int SWAMP;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;

    public int m_6949_(Context context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        int[] outBiomeId = new int[1];
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.alps, BOPBiomes.alps_foothills)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.redwood_forest, BOPBiomes.redwood_forest_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.redwood_hills, BOPBiomes.redwood_forest_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.volcano, BOPBiomes.volcanic_plains)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, WOODED_BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, GIANT_TREE_TAIGA, TAIGA)) {
            return outBiomeId[0];
        }
        if (biomeId == DESERT && (northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA)) {
            return WOODED_MOUNTAINS;
        }
        if (biomeId == SWAMP) {
            if (northBiomeId == DESERT || eastBiomeId == DESERT || westBiomeId == DESERT || southBiomeId == DESERT || northBiomeId == SNOWY_TAIGA || eastBiomeId == SNOWY_TAIGA || westBiomeId == SNOWY_TAIGA || southBiomeId == SNOWY_TAIGA || northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA) {
                return PLAINS;
            }
            if (northBiomeId == JUNGLE || southBiomeId == JUNGLE || eastBiomeId == JUNGLE || westBiomeId == JUNGLE || northBiomeId == JUNGLE_HILLS || southBiomeId == JUNGLE_HILLS || eastBiomeId == JUNGLE_HILLS || westBiomeId == JUNGLE_HILLS) {
                return JUNGLE_EDGE;
            }
        }
        return biomeId;
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, ResourceKey<Biome> fromBiome, ResourceKey<Biome> toBiome) {
        return BiomeUtil.exists(fromBiome) && BiomeUtil.exists(toBiome) && this.replaceBiomeEdge(outId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BiomeUtil.getBiomeId(fromBiome), BiomeUtil.getBiomeId(toBiome));
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, int fromBiome, int toBiome) {
        if (biomeId != fromBiome) {
            return false;
        }
        outId[0] = Layers.m_76723_((int)northBiomeId, (int)fromBiome) && Layers.m_76723_((int)eastBiomeId, (int)fromBiome) && Layers.m_76723_((int)westBiomeId, (int)fromBiome) && Layers.m_76723_((int)southBiomeId, (int)fromBiome) ? biomeId : toBiome;
        return true;
    }

    static {
        DESERT = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48203_);
        MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48204_);
        WOODED_MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48156_);
        SNOWY_TUNDRA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48213_);
        JUNGLE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48222_);
        JUNGLE_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48223_);
        JUNGLE_EDGE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48224_);
        BADLANDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48159_);
        BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48161_);
        WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48160_);
        PLAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48202_);
        GIANT_TREE_TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48154_);
        MOUNTAIN_EDGE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48221_);
        SWAMP = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48207_);
        TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48206_);
        SNOWY_TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48152_);
    }
}

