/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import biomesoplenty.common.world.layer.traits.IAreaTransformer3;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.traits.DimensionOffset0Transformer;

public enum BOPMixOceansLayer implements IAreaTransformer3,
DimensionOffset0Transformer
{
    INSTANCE;


    @Override
    public int applyPixel(Context context, Area biomeArea, Area oceanArea, Area climateArea, int x, int z) {
        int biomeId = biomeArea.m_7929_(x, z);
        int oceanId = oceanArea.m_7929_(x, z);
        int climateVal = climateArea.m_7929_(x, z);
        BOPClimates climate = BOPClimates.lookup(climateVal);
        if (!BOPLayerUtil.isOcean(biomeId)) {
            return biomeId;
        }
        switch (climate) {
            case ICE_CAP: {
                oceanId = BOPLayerUtil.FROZEN_OCEAN;
                break;
            }
            case TUNDRA: 
            case WET_BOREAL: 
            case DRY_BOREAL: {
                oceanId = BOPLayerUtil.COLD_OCEAN;
                break;
            }
            case WARM_TEMPERATE: 
            case SUBTROPICAL: 
            case MEDITERRANEAN: 
            case SAVANNA: {
                oceanId = BOPLayerUtil.LUKEWARM_OCEAN;
                break;
            }
            case TROPICAL: 
            case HOT_DESERT: {
                oceanId = BOPLayerUtil.WARM_OCEAN;
                break;
            }
            default: {
                oceanId = BOPLayerUtil.OCEAN;
            }
        }
        if (biomeId == BOPLayerUtil.DEEP_OCEAN) {
            if (oceanId == BOPLayerUtil.WARM_OCEAN) {
                return BOPLayerUtil.DEEP_WARM_OCEAN;
            }
            if (oceanId == BOPLayerUtil.LUKEWARM_OCEAN) {
                return BOPLayerUtil.DEEP_LUKEWARM_OCEAN;
            }
            if (oceanId == BOPLayerUtil.OCEAN) {
                return BOPLayerUtil.DEEP_OCEAN;
            }
            if (oceanId == BOPLayerUtil.COLD_OCEAN) {
                return BOPLayerUtil.DEEP_COLD_OCEAN;
            }
            if (oceanId == BOPLayerUtil.FROZEN_OCEAN) {
                return BOPLayerUtil.DEEP_FROZEN_OCEAN;
            }
            if (BiomeUtil.exists(BOPBiomes.wasteland) && oceanId == BiomeUtil.getBiomeId(BOPBiomes.wasteland)) {
                return BiomeUtil.getBiomeId(BOPBiomes.wasteland);
            }
        }
        return oceanId;
    }
}

