/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer2;
import net.minecraft.world.level.newbiome.layer.traits.DimensionOffset0Transformer;

public enum BOPRiverMixLayer implements AreaTransformer2,
DimensionOffset0Transformer
{
    INSTANCE;

    private static final int FROZEN_RIVER;
    private static final int SNOWY_TUNDRA;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;

    public int m_5924_(Context context, Area biomeArea, Area riverArea, int x, int z) {
        int biomeId = biomeArea.m_7929_(x, z);
        int riverId = riverArea.m_7929_(x, z);
        ResourceKey<Biome> biome = BiomeUtil.createKey(biomeId);
        if (BOPLayerUtil.isOcean(biomeId)) {
            return biomeId;
        }
        if (riverId == RIVER) {
            if (biomeId == SNOWY_TUNDRA) {
                return FROZEN_RIVER;
            }
            if (BiomeUtil.hasMetadata(biome)) {
                BiomeMetadata meta = BiomeUtil.getMetadata(biome);
                if (meta.getRiverBiome() != null) {
                    return BiomeUtil.getBiomeId(meta.getRiverBiome());
                }
                return biomeId;
            }
            return biomeId != MUSHROOM_FIELDS && biomeId != MUSHROOM_FIELD_SHORE ? riverId & 0xFF : MUSHROOM_FIELD_SHORE;
        }
        return biomeId;
    }

    static {
        FROZEN_RIVER = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48212_);
        SNOWY_TUNDRA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48213_);
        MUSHROOM_FIELDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48215_);
        MUSHROOM_FIELD_SHORE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48216_);
        RIVER = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48208_);
    }
}

