/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.traits.CastleTransformer;

public enum BOPShoreLayer implements CastleTransformer
{
    INSTANCE;

    private static final int BEACH;
    private static final int SNOWY_BEACH;
    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int BADLANDS_PLATEAU;
    private static final int ERODED_BADLANDS;
    private static final int MODIFIED_WOODED_BADLANDS_PLATEAU;
    private static final int MODIFIED_BADLANDS_PLATEAU;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;
    private static final int MOUNTAIN_EDGE;
    private static final int STONE_SHORE;
    private static final int SWAMP;
    private static final int TAIGA;

    public int m_6949_(Context context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        Biome biome = BiomeUtil.getBiome(biomeId);
        ResourceKey<Biome> key = BiomeUtil.createKey(biome);
        if (biomeId == MUSHROOM_FIELDS) {
            if (BOPLayerUtil.isShallowOcean(northBiomeId) || BOPLayerUtil.isShallowOcean(eastBiomeId) || BOPLayerUtil.isShallowOcean(southBiomeId) || BOPLayerUtil.isShallowOcean(westBiomeId)) {
                return MUSHROOM_FIELD_SHORE;
            }
        } else if (biome != null && biome.m_47567_() == Biome.BiomeCategory.JUNGLE && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest_floodplain, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest_cliffs, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.fungal_jungle, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.fungal_field, biomeId)) {
            if (!(BOPShoreLayer.isJungleCompatible(northBiomeId) && BOPShoreLayer.isJungleCompatible(eastBiomeId) && BOPShoreLayer.isJungleCompatible(southBiomeId) && BOPShoreLayer.isJungleCompatible(westBiomeId))) {
                return JUNGLE_EDGE;
            }
        } else if (biomeId != MOUNTAINS && biomeId != WOODED_MOUNTAINS && biomeId != MOUNTAIN_EDGE) {
            if (biome != null && biome.m_47530_() == Biome.Precipitation.SNOW) {
                if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    BiomeMetadata meta;
                    if (BiomeUtil.hasMetadata(biome) && (meta = BiomeUtil.getMetadata(biome)).getBeachBiome() == null) {
                        return biomeId;
                    }
                    return SNOWY_BEACH;
                }
            } else if (biomeId != BADLANDS && biomeId != WOODED_BADLANDS_PLATEAU) {
                if (!BOPLayerUtil.isOcean(biomeId) && biomeId != RIVER && biomeId != SWAMP && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    if (BiomeUtil.hasMetadata(biome)) {
                        BiomeMetadata meta = BiomeUtil.getMetadata(biome);
                        return BOPShoreLayer.getBiomeIdIfPresent(meta.getBeachBiome(), biomeId);
                    }
                    if (key == Biomes.f_48206_ || key == Biomes.f_48180_ || key == Biomes.f_48220_ || key == Biomes.f_48154_ || key == Biomes.f_48189_ || key == Biomes.f_48155_ || key == Biomes.f_48190_ || key == Biomes.f_48150_ || key == Biomes.f_48149_ || key == Biomes.f_48186_ || key == Biomes.f_48185_ || key == Biomes.f_48187_ || key == Biomes.f_48151_ || key == Biomes.f_48205_ || key == Biomes.f_48179_ || key == Biomes.f_48219_) {
                        return BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.gravel_beach, biomeId);
                    }
                    return BEACH;
                }
            } else if (!(BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId) || BOPShoreLayer.isMesa(northBiomeId) && BOPShoreLayer.isMesa(eastBiomeId) && BOPShoreLayer.isMesa(southBiomeId) && BOPShoreLayer.isMesa(westBiomeId))) {
                return DESERT;
            }
        } else if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
            return STONE_SHORE;
        }
        return biomeId;
    }

    private static int getBiomeIdIfPresent(ResourceKey<Biome> biome, int fallbackId) {
        return biome != null && BiomeUtil.exists(biome) ? BiomeUtil.getBiomeId(biome) : fallbackId;
    }

    private static boolean isJungleCompatible(int biomeId) {
        Biome biome = BiomeUtil.getBiome(biomeId);
        if (biome != null && biome.m_47567_() == Biome.BiomeCategory.JUNGLE) {
            return true;
        }
        return biomeId == JUNGLE_EDGE || biomeId == JUNGLE || biomeId == JUNGLE_HILLS || biomeId == FOREST || biomeId == TAIGA || BOPLayerUtil.isOcean(biomeId);
    }

    private static boolean isMesa(int biomeId) {
        return biomeId == BADLANDS || biomeId == WOODED_BADLANDS_PLATEAU || biomeId == BADLANDS_PLATEAU || biomeId == ERODED_BADLANDS || biomeId == MODIFIED_WOODED_BADLANDS_PLATEAU || biomeId == MODIFIED_BADLANDS_PLATEAU;
    }

    static {
        BEACH = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48217_);
        SNOWY_BEACH = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48148_);
        DESERT = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48203_);
        MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48204_);
        WOODED_MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48156_);
        FOREST = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48205_);
        JUNGLE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48222_);
        JUNGLE_EDGE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48224_);
        JUNGLE_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48223_);
        BADLANDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48159_);
        WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48160_);
        BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48161_);
        ERODED_BADLANDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48194_);
        MODIFIED_WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48195_);
        MODIFIED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48196_);
        MUSHROOM_FIELDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48215_);
        MUSHROOM_FIELD_SHORE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48216_);
        RIVER = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48208_);
        MOUNTAIN_EDGE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48221_);
        STONE_SHORE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48226_);
        SWAMP = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48207_);
        TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48206_);
    }
}

