/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import biomesoplenty.init.ModBiomes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.Layers;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer2;
import net.minecraft.world.level.newbiome.layer.traits.DimensionOffset0Transformer;

public enum SubBiomeLayer implements AreaTransformer2,
DimensionOffset0Transformer
{
    INSTANCE;

    private static final int BIRCH_FOREST;
    private static final int BIRCH_FOREST_HILLS;
    private static final int DESERT;
    private static final int DESERT_HILLS;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int WOODED_HILLS;
    private static final int SNOWY_TUNDRA;
    private static final int SNOWY_MOUNTAINS;
    private static final int JUNGLE;
    private static final int JUNGLE_HILLS;
    private static final int BAMBOO_JUNGLE;
    private static final int BAMBOO_JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int GIANT_TREE_TAIGA_HILLS;
    private static final int DARK_FOREST;
    private static final int SAVANNA;
    private static final int SAVANA_PLATEAU;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;
    private static final int SNOWY_TAIGA_HILLS;
    private static final int TAIGA_HILLS;
    private static final Int2IntMap MUTATIONS;

    public int m_5924_(Context context, Area biomeArea, Area riverAndSubBiomesInitArea, int x, int z) {
        boolean tryRareBiome;
        int biomeId = biomeArea.m_7929_(this.m_6320_(x + 1), this.m_6317_(z + 1));
        int initVal = riverAndSubBiomesInitArea.m_7929_(this.m_6320_(x + 1), this.m_6317_(z + 1));
        int subBiomeType = (initVal - 2) % 29;
        boolean tryRareHillsBiome = subBiomeType == 0;
        boolean bl = tryRareBiome = subBiomeType == 1;
        if (!BOPLayerUtil.isShallowOcean(biomeId) && initVal >= 2 && tryRareBiome) {
            return MUTATIONS.getOrDefault(biomeId, biomeId);
        }
        if (context.m_5826_(3) == 0 || tryRareHillsBiome) {
            int mutatedBiomeId = this.getCommonSubBiomeId(context, biomeId);
            if (mutatedBiomeId != biomeId) {
                return mutatedBiomeId;
            }
            mutatedBiomeId = this.getRareSubBiomeId(context, biomeId);
            if (subBiomeType == 0 && mutatedBiomeId != biomeId) {
                mutatedBiomeId = MUTATIONS.getOrDefault(mutatedBiomeId, biomeId);
            }
            if (mutatedBiomeId != biomeId) {
                int surroundingSimilarCount = 0;
                if (Layers.m_76723_((int)biomeArea.m_7929_(x + 1, z + 0), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (Layers.m_76723_((int)biomeArea.m_7929_(x + 2, z + 1), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (Layers.m_76723_((int)biomeArea.m_7929_(x + 0, z + 1), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (Layers.m_76723_((int)biomeArea.m_7929_(x + 1, z + 2), (int)biomeId)) {
                    ++surroundingSimilarCount;
                }
                if (surroundingSimilarCount >= 3) {
                    return mutatedBiomeId;
                }
            }
        }
        return biomeId;
    }

    public int getCommonSubBiomeId(Context context, int originalBiomeId) {
        BOPClimates.WeightedBiomeEntry item;
        float rarity = (float)context.m_5826_(100) / 100.0f;
        ArrayList weightedBiomeEntryList = Lists.newArrayList();
        int selectedBiomeId = originalBiomeId;
        int totalWeight = 0;
        for (ModBiomes.WeightedSubBiome entry : ModBiomes.subBiomes.get((Object)originalBiomeId)) {
            if (!(entry.rarity >= rarity)) continue;
            weightedBiomeEntryList.add(new BOPClimates.WeightedBiomeEntry(entry.weight, entry.biome));
            totalWeight += entry.weight;
        }
        if (totalWeight <= 0) {
            return selectedBiomeId;
        }
        int weight = context.m_5826_(totalWeight);
        Iterator iterator = weightedBiomeEntryList.iterator();
        do {
            item = (BOPClimates.WeightedBiomeEntry)iterator.next();
        } while ((weight -= item.weight) >= 0);
        selectedBiomeId = BiomeUtil.getBiomeId(item.biome);
        return selectedBiomeId;
    }

    public int getRareSubBiomeId(Context context, int originalBiomeId) {
        int mutatedBiomeId = originalBiomeId;
        if (originalBiomeId == DESERT) {
            mutatedBiomeId = DESERT_HILLS;
        } else if (originalBiomeId == FOREST) {
            mutatedBiomeId = WOODED_HILLS;
        } else if (originalBiomeId == BIRCH_FOREST) {
            mutatedBiomeId = BIRCH_FOREST_HILLS;
        } else if (originalBiomeId == DARK_FOREST) {
            mutatedBiomeId = PLAINS;
        } else if (originalBiomeId == TAIGA) {
            mutatedBiomeId = TAIGA_HILLS;
        } else if (originalBiomeId == GIANT_TREE_TAIGA) {
            mutatedBiomeId = GIANT_TREE_TAIGA_HILLS;
        } else if (originalBiomeId == SNOWY_TAIGA) {
            mutatedBiomeId = SNOWY_TAIGA_HILLS;
        } else if (originalBiomeId == PLAINS && BiomeUtil.exists(BOPBiomes.orchard)) {
            mutatedBiomeId = BiomeUtil.getBiomeId(BOPBiomes.orchard);
        } else if (originalBiomeId == SNOWY_TUNDRA) {
            mutatedBiomeId = SNOWY_MOUNTAINS;
        } else if (originalBiomeId == JUNGLE) {
            mutatedBiomeId = JUNGLE_HILLS;
        } else if (originalBiomeId == BAMBOO_JUNGLE) {
            mutatedBiomeId = BAMBOO_JUNGLE_HILLS;
        } else if (originalBiomeId == BOPLayerUtil.OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.LUKEWARM_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_LUKEWARM_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.COLD_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_COLD_OCEAN;
        } else if (originalBiomeId == BOPLayerUtil.FROZEN_OCEAN) {
            mutatedBiomeId = BOPLayerUtil.DEEP_FROZEN_OCEAN;
        } else if (originalBiomeId == MOUNTAINS) {
            mutatedBiomeId = WOODED_MOUNTAINS;
        } else if (originalBiomeId == SAVANNA) {
            mutatedBiomeId = SAVANA_PLATEAU;
        } else if (Layers.m_76723_((int)originalBiomeId, (int)WOODED_BADLANDS_PLATEAU)) {
            mutatedBiomeId = BADLANDS;
        } else if ((originalBiomeId == BOPLayerUtil.DEEP_OCEAN || originalBiomeId == BOPLayerUtil.DEEP_LUKEWARM_OCEAN) && context.m_5826_(3) == 0) {
            mutatedBiomeId = BiomeUtil.exists(BOPBiomes.dunes) ? BiomeUtil.getBiomeId(BOPBiomes.dunes) : originalBiomeId;
        }
        return mutatedBiomeId;
    }

    static {
        BIRCH_FOREST = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48149_);
        BIRCH_FOREST_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48150_);
        DESERT = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48203_);
        DESERT_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48218_);
        MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48204_);
        WOODED_MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48156_);
        FOREST = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48205_);
        WOODED_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48219_);
        SNOWY_TUNDRA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48213_);
        SNOWY_MOUNTAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48214_);
        JUNGLE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48222_);
        JUNGLE_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48223_);
        BAMBOO_JUNGLE = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48197_);
        BAMBOO_JUNGLE_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48198_);
        BADLANDS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48159_);
        WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48160_);
        PLAINS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48202_);
        GIANT_TREE_TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48154_);
        GIANT_TREE_TAIGA_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48155_);
        DARK_FOREST = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48151_);
        SAVANNA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48157_);
        SAVANA_PLATEAU = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48158_);
        TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48206_);
        SNOWY_TAIGA = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48152_);
        SNOWY_TAIGA_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48153_);
        TAIGA_HILLS = BiomeUtil.getBiomeId((ResourceKey<Biome>)Biomes.f_48220_);
        MUTATIONS = (Int2IntMap)Util.m_137469_((Object)new Int2IntOpenHashMap(), map -> {
            map.put(1, 129);
            map.put(2, 130);
            map.put(3, 131);
            map.put(4, 132);
            map.put(5, 133);
            map.put(6, 134);
            map.put(12, 140);
            map.put(21, 149);
            map.put(23, 151);
            map.put(27, 155);
            map.put(28, 156);
            map.put(29, 157);
            map.put(30, 158);
            map.put(32, 160);
            map.put(33, 161);
            map.put(34, 162);
            map.put(35, 163);
            map.put(36, 164);
            map.put(37, 165);
            map.put(38, 166);
            map.put(39, 167);
        });
    }
}

