/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.enums.BOPClimates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public class ModCompatibility {
    public static void setup() {
        ModCompatibility.copyModBiomeWeights();
    }

    private static void copyModBiomeWeights() {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            List moddedBiomesInType = BiomeManager.getBiomes((BiomeManager.BiomeType)type).stream().filter(biomeEntry -> !biomeEntry.getKey().m_135782_().m_135827_().equals("minecraft")).collect(Collectors.toList());
            moddedBiomesInType.stream().forEach(biomeEntry -> ModCompatibility.remapBiomeToBoP((ResourceKey<Biome>)biomeEntry.getKey(), type, biomeEntry.f_14482_));
        }
    }

    private static void remapBiomeToBoP(ResourceKey<Biome> biome, BiomeManager.BiomeType type, int weight) {
        for (BOPClimates climate : BOPClimates.values()) {
            ArrayList entries = Lists.newArrayList();
            entries.addAll(climate.getLandBiomes());
            entries.addAll(climate.getIslandBiomes());
            for (BOPClimates.WeightedBiomeEntry entry : entries) {
                if (entry.biome != biome) continue;
                return;
            }
        }
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate.biomeType != type) continue;
            climate.addBiome(weight, biome);
        }
    }
}

