/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.common.world.BOPOverworldGenSettings;
import biomesoplenty.core.BiomesOPlenty;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModConfig {
    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path bopConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "biomesoplenty");
        try {
            Files.createDirectory(bopConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            BiomesOPlenty.logger.error("Failed to create biomesoplenty config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GenerationConfig.SPEC, "biomesoplenty/generation.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "biomesoplenty/client.toml");
    }

    public static class GenerationConfig {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.EnumValue<BOPOverworldGenSettings.BiomeSize> biomeSize;
        public static final ForgeConfigSpec.EnumValue<BOPOverworldGenSettings.RiverSize> riverSize;
        public static final ForgeConfigSpec.EnumValue<BOPOverworldGenSettings.TemperatureVariationScheme> temperatureVariationScheme;
        public static final ForgeConfigSpec.EnumValue<BOPOverworldGenSettings.RainfallVariationScheme> rainfallVariationScheme;
        public static final ForgeConfigSpec.BooleanValue enhanceVanillaBiomes;
        public static final ForgeConfigSpec.BooleanValue useBopNether;

        static {
            BUILDER.comment("World generation related options.");
            BUILDER.push("overworld");
            biomeSize = BUILDER.comment("The size of generated biomes.").defineEnum("biome_size", (Enum)BOPOverworldGenSettings.BiomeSize.MEDIUM);
            riverSize = BUILDER.comment("The size of generated rivers.").defineEnum("river_size", (Enum)BOPOverworldGenSettings.RiverSize.MEDIUM);
            temperatureVariationScheme = BUILDER.comment("Type of temperature zones to use during biome placement.").defineEnum("temperature_variation_scheme", (Enum)BOPOverworldGenSettings.TemperatureVariationScheme.MEDIUM_ZONES);
            rainfallVariationScheme = BUILDER.comment("Type of rainfall zones to use during biome placement.").defineEnum("rainfall_variation_scheme", (Enum)BOPOverworldGenSettings.RainfallVariationScheme.MEDIUM_ZONES);
            enhanceVanillaBiomes = BUILDER.comment("Enhance vanilla biomes by adding additional decoration.").define("enhance_vanilla_biomes", true);
            useBopNether = BUILDER.comment("Enable nether generation from Biomes O' Plenty.").define("use_bop_nether", true);
            BUILDER.pop();
            SPEC = BUILDER.build();
        }
    }

    public static class ClientConfig {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.BooleanValue useWorldType;

        static {
            BUILDER.comment("Client-related options.");
            BUILDER.push("gui");
            useWorldType = BUILDER.comment("Select the Biomes O' Plenty world type by default.").define("use_world_type", true);
            BUILDER.pop();
            SPEC = BUILDER.build();
        }
    }
}

