/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    public static final float MAX_FOV = 90.0f;
    public static final float MIN_FOV = 5.0f;
    private Minecraft mc = Minecraft.m_91087_();
    private boolean inCameraMode = false;
    private float fov = 0.0f;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        this.mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        this.setShader(this.getShader((Player)this.mc.f_91074_));
        this.drawViewFinder(event.getMatrixStack());
        this.drawZoom(event.getMatrixStack(), this.getFOVPercentage());
    }

    private void drawViewFinder(PoseStack matrixStack) {
        float hnew;
        float wnew;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float ws = this.mc.m_91268_().m_85445_();
        float hs = this.mc.m_91268_().m_85446_();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, left, top, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, left, top + hnew, 0.0f).m_7421_(0.0f, 0.390625f).m_5752_();
        buffer.m_85982_(matrix, left + wnew, top + hnew, 0.0f).m_7421_(0.75f, 0.390625f).m_5752_();
        buffer.m_85982_(matrix, left + wnew, top, 0.0f).m_7421_(0.75f, 0.0f).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
    }

    private void drawZoom(PoseStack matrixStack, float percent) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int width = this.mc.m_91268_().m_85445_();
        int height = this.mc.m_91268_().m_85446_();
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, (float)left, (float)top, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).m_7421_(0.0f, 0.078125f).m_5752_();
        buffer.m_85982_(matrix, (float)(left + zoomWidth), (float)(top + zoomHeight / 2), 0.0f).m_7421_(0.875f, 0.078125f).m_5752_();
        buffer.m_85982_(matrix, (float)(left + zoomWidth), (float)top, 0.0f).m_7421_(0.875f, 0.0f).m_5752_();
        int percWidth = (int)(Math.max(Math.min((double)percent, 1.0), 0.0) * (double)zoomWidth);
        buffer.m_85982_(matrix, (float)left, (float)top, 0.0f).m_7421_(0.0f, 0.078125f).m_5752_();
        buffer.m_85982_(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).m_7421_(0.0f, 0.15625f).m_5752_();
        buffer.m_85982_(matrix, (float)(left + percWidth), (float)(top + zoomHeight / 2), 0.0f).m_7421_(0.875f * percent, 0.15625f).m_5752_();
        buffer.m_85982_(matrix, (float)(left + percWidth), (float)top, 0.0f).m_7421_(0.875f * percent, 0.078125f).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.inCameraMode && event.getGui() instanceof PauseScreen) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals((Object)Main.CAMERA)) continue;
            return Shaders.getShader(Main.CAMERA.getShader(stack));
        }
        return null;
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            if (this.currentShader != null) {
                this.mc.f_91063_.m_109086_();
            }
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.f_91063_.m_109128_(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getPlayer();
        if (player == this.mc.f_91074_) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof CameraItem) || !Main.CAMERA.isActive(stack)) continue;
            player.m_6672_(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Player player = event.getPlayer();
        if (player == this.mc.f_91074_) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getPlayer().m_5810_();
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (event.getScrollDelta() == 0.0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getScrollDelta() < 0.0 ? Math.min(this.fov + 5.0f, 90.0f) : Math.max(this.fov - 5.0f, 5.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (!this.inCameraMode) {
            this.fov = (float)this.mc.f_91066_.f_92068_;
            return;
        }
        this.mc.f_91074_.m_6034_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_() + 1.0E-9, this.mc.f_91074_.m_20189_());
        event.setFOV((double)this.fov);
    }

    public float getFOVPercentage() {
        return 1.0f - (this.fov - 5.0f) / 85.0f;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.f_91074_ == null) {
            return null;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = this.mc.f_91074_.m_21120_(hand);
            if (!stack.m_41720_().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

