/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ClientConfig;
import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.RecipeImageCloning;
import de.maxhenkel.camera.ServerConfig;
import de.maxhenkel.camera.ServerEvents;
import de.maxhenkel.camera.corelib.ClientRegistry;
import de.maxhenkel.camera.corelib.CommonRegistry;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageRenderer;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.gui.AlbumInventoryScreen;
import de.maxhenkel.camera.gui.LecternAlbumScreen;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.items.ImageFrameItem;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageAlbumPage;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeBook;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import de.maxhenkel.camera.net.PacketManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camera")
public class Main {
    public static final String MODID = "camera";
    public static final Logger LOGGER = LogManager.getLogger((String)"camera");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static PacketManager PACKET_MANAGER;
    public static SimpleRecipeSerializer<RecipeImageCloning> CRAFTING_SPECIAL_IMAGE_CLONING;
    public static ImageFrameItem FRAME_ITEM;
    public static CameraItem CAMERA;
    public static ImageItem IMAGE;
    public static AlbumItem ALBUM;
    public static MenuType<AlbumInventoryContainer> ALBUM_INVENTORY_CONTAINER;
    public static MenuType<AlbumContainer> ALBUM_CONTAINER;
    public static EntityType<ImageEntity> IMAGE_ENTITY_TYPE;
    public static Tag<Item> IMAGE_PAPER;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_NEXT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_PREVIOUS;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(MenuType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        PACKET_MANAGER = new PacketManager();
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessagePartialImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageTakeImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageRequestImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageImageUnavailable.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 5, MessageSetShader.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 6, MessageDisableCameraMode.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 7, MessageResizeFrame.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 8, MessageRequestUploadCustomImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 9, MessageUploadCustomImage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 10, MessageAlbumPage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 11, MessageTakeBook.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        KEY_NEXT = ClientRegistry.registerKeyBinding("key.next_image", "key.categories.misc", 264);
        KEY_PREVIOUS = ClientRegistry.registerKeyBinding("key.previous_image", "key.categories.misc", 265);
        ClientRegistry.registerScreen(ALBUM_INVENTORY_CONTAINER, AlbumInventoryScreen::new);
        ClientRegistry.registerScreen(ALBUM_CONTAINER, LecternAlbumScreen::new);
        EntityRenderers.m_174036_(IMAGE_ENTITY_TYPE, ImageRenderer::new);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[4];
        FRAME_ITEM = new ImageFrameItem();
        itemArray[0] = FRAME_ITEM;
        CAMERA = new CameraItem();
        itemArray[1] = CAMERA;
        IMAGE = new ImageItem();
        itemArray[2] = IMAGE;
        ALBUM = new AlbumItem();
        itemArray[3] = ALBUM;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{ModSounds.TAKE_IMAGE});
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IMAGE_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, "image_frame", MobCategory.MISC, ImageEntity.class, builder -> builder.setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).m_20699_(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new ImageEntity((Level)world)));
        event.getRegistry().register(IMAGE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        ALBUM_INVENTORY_CONTAINER = new MenuType(AlbumInventoryContainer::new);
        ALBUM_INVENTORY_CONTAINER.setRegistryName(new ResourceLocation(MODID, "album_inventory"));
        event.getRegistry().register(ALBUM_INVENTORY_CONTAINER);
        ALBUM_CONTAINER = new MenuType((i, playerInventory) -> new AlbumContainer(i));
        ALBUM_CONTAINER.setRegistryName(new ResourceLocation(MODID, "album"));
        event.getRegistry().register(ALBUM_CONTAINER);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CRAFTING_SPECIAL_IMAGE_CLONING = new SimpleRecipeSerializer(RecipeImageCloning::new);
        CRAFTING_SPECIAL_IMAGE_CLONING.setRegistryName(MODID, "crafting_special_imagecloning");
        event.getRegistry().register(CRAFTING_SPECIAL_IMAGE_CLONING);
    }

    static {
        IMAGE_PAPER = ItemTags.m_13194_((String)new ResourceLocation(MODID, "image_paper").toString());
    }
}

