/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.torchbandolier;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.PlaceHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;

public class TorchBandolierCompat
implements ICeilingTorchCompat {
    public TorchBandolierCompat() {
        MinecraftForge.EVENT_BUS.addListener(TorchBandolierCompat::onRightClickBlock);
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getFace() == Direction.DOWN && event.getItemStack().m_41720_() instanceof TorchBandolierItem) {
            ICeilingTorchCompat compat;
            Map<ResourceLocation, Block> placeEntries;
            String modid;
            Player player = event.getPlayer();
            ItemStack stack = event.getItemStack();
            TorchBandolierItem bandolier = (TorchBandolierItem)stack.m_41720_();
            Block torch = bandolier.getTorchBlock();
            boolean consumeTorch = player != null && !player.m_7500_();
            int torchCount = TorchBandolierItem.getTorchCount((ItemStack)stack);
            if (player == null || torch == null || torch instanceof AirBlock || torchCount <= 0 && consumeTorch) {
                return;
            }
            ResourceLocation rl = torch.m_5456_().getRegistryName();
            Map<String, ICeilingTorchCompat> compatList = CeilingTorch.getCompatList();
            if (compatList.containsKey(modid = rl.m_135827_()) && (placeEntries = (compat = compatList.get(modid)).getPlaceEntries()).containsKey(rl)) {
                Block block = placeEntries.get(rl);
                BlockPos pos = event.getPos();
                BlockState state = compat.getStateToPlace(stack, block);
                if (PlaceHandler.placeTorch(compat, event, ItemStack.f_41583_, block, pos, pos.m_142300_(event.getFace()), event.getWorld(), state)) {
                    if (consumeTorch) {
                        TorchBandolierItem.setTorchCount((ItemStack)stack, (int)(--torchCount));
                    }
                    if (torchCount == 0 && player != null) {
                        player.m_150109_().m_6836_(player.m_150109_().m_36030_(stack), new ItemStack((ItemLike)ModItems.EMPTY_TORCH_BANDOLIER.get()));
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            }
        }
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        return ImmutableMap.of();
    }
}

