/*
 * Decompiled with CFR 0.152.
 */
package net.coldsweat;

import java.util.function.Supplier;
import net.coldsweat.ColdSweatMod;
import net.coldsweat.ColdSweatModElements;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ColdSweatModVariables {
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    public ColdSweatModVariables(ColdSweatModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
        elements.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    private void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.func_201670_d() && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("cold_sweat", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        clone.syncedCelsius = original.syncedCelsius;
        if (!event.isWasDeath()) {
            clone.syncedTemp = original.syncedTemp;
            clone.syncedWorldTemp = original.syncedWorldTemp;
            clone.syncedBlockTemp = original.syncedBlockTemp;
            clone.syncedDepth = original.syncedDepth;
            clone.syncedGracePeriod = original.syncedGracePeriod;
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.syncedTemp = message.data.syncedTemp;
                    variables.syncedCelsius = message.data.syncedCelsius;
                    variables.syncedWorldTemp = message.data.syncedWorldTemp;
                    variables.syncedBlockTemp = message.data.syncedBlockTemp;
                    variables.syncedDepth = message.data.syncedDepth;
                    variables.syncedGracePeriod = message.data.syncedGracePeriod;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double syncedTemp = 0.0;
        public boolean syncedCelsius = false;
        public double syncedWorldTemp = 75.0;
        public double syncedBlockTemp = 0.0;
        public double syncedDepth = 0.0;
        public boolean syncedGracePeriod = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("syncedTemp", instance.syncedTemp);
            nbt.func_74757_a("syncedCelsius", instance.syncedCelsius);
            nbt.func_74780_a("syncedWorldTemp", instance.syncedWorldTemp);
            nbt.func_74780_a("syncedBlockTemp", instance.syncedBlockTemp);
            nbt.func_74780_a("syncedDepth", instance.syncedDepth);
            nbt.func_74757_a("syncedGracePeriod", instance.syncedGracePeriod);
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.syncedTemp = nbt.func_74769_h("syncedTemp");
            instance.syncedCelsius = nbt.func_74767_n("syncedCelsius");
            instance.syncedWorldTemp = nbt.func_74769_h("syncedWorldTemp");
            instance.syncedBlockTemp = nbt.func_74769_h("syncedBlockTemp");
            instance.syncedDepth = nbt.func_74769_h("syncedDepth");
            instance.syncedGracePeriod = nbt.func_74767_n("syncedGracePeriod");
        }
    }

    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, (Object)((PlayerVariables)this.instance.orElseThrow(RuntimeException::new)), null, nbt);
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "cold_sweat_mapvars";
        public double minimumHabitable = 50.0;
        public double maximumHabitable = 100.0;
        public double undergroundHeight = 64.0;
        public double rainChance = 15.0;
        public double rainLength = 72.0;
        public double rainTimeLeft = 0.0;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.minimumHabitable = nbt.func_74769_h("minimumHabitable");
            this.maximumHabitable = nbt.func_74769_h("maximumHabitable");
            this.undergroundHeight = nbt.func_74769_h("undergroundHeight");
            this.rainChance = nbt.func_74769_h("rainChance");
            this.rainLength = nbt.func_74769_h("rainLength");
            this.rainTimeLeft = nbt.func_74769_h("rainTimeLeft");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("minimumHabitable", this.minimumHabitable);
            nbt.func_74780_a("maximumHabitable", this.maximumHabitable);
            nbt.func_74780_a("undergroundHeight", this.undergroundHeight);
            nbt.func_74780_a("rainChance", this.rainChance);
            nbt.func_74780_a("rainLength", this.rainLength);
            nbt.func_74780_a("rainTimeLeft", this.rainTimeLeft);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world instanceof IServerWorld) {
                return (MapVariables)((IServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "cold_sweat_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                ColdSweatMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((World)((World)world)).func_234923_W_()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

