/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.config;

import com.shynieke.coupons.Coupons;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CouponConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Coupons.LOGGER.debug("Loaded Coupon's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        Coupons.LOGGER.debug("Coupon's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue doubleBossLoot;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;
        public final ForgeConfigSpec.BooleanValue enableBrewingCoupon;
        public final ForgeConfigSpec.BooleanValue enableCraftingCoupon;
        public final ForgeConfigSpec.BooleanValue enableExperienceCoupon;
        public final ForgeConfigSpec.BooleanValue enableFurnaceCoupon;
        public final ForgeConfigSpec.BooleanValue enableLootCoupon;
        public final ForgeConfigSpec.BooleanValue enableTradingCoupon;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.doubleBossLoot = builder.comment("When enabled the loot coupon can double boss loot").define("doubleBossLoot", false);
            String[] entities = new String[]{""};
            this.entityBlacklist = builder.comment("A list of entities that can't have loot doubled [Syntax: 'minecraft:bat']").defineList("entityBlacklist", Arrays.asList(entities), o -> o instanceof String);
            builder.pop();
            builder.comment("Wandering Trader Trades").push("Trades");
            this.enableBrewingCoupon = builder.comment("Defines whether or not the Brewing Coupon is obtainable from the Wandering Trader").worldRestart().define("enableBrewingCoupon", true);
            this.enableCraftingCoupon = builder.comment("Defines whether or not the Crafting Coupon is obtainable from the Wandering Trader").worldRestart().define("enableCraftingCoupon", true);
            this.enableExperienceCoupon = builder.comment("Defines whether or not the Experience Coupon is obtainable from the Wandering Trader").worldRestart().define("enableExperienceCoupon", true);
            this.enableFurnaceCoupon = builder.comment("Defines whether or not the Furnace Coupon is obtainable from the Wandering Trader").worldRestart().define("enableFurnaceCoupon", true);
            this.enableLootCoupon = builder.comment("Defines whether or not the Loot Coupon is obtainable from the Wandering Trader").worldRestart().define("enableLootCoupon", true);
            this.enableTradingCoupon = builder.comment("Defines whether or not the Trading Coupon is obtainable from the Wandering Trader").worldRestart().define("enableTradingCoupon", true);
            builder.pop();
        }
    }
}

