/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.handler;

import com.shynieke.coupons.CouponRegistry;
import com.shynieke.coupons.config.CouponConfig;
import com.shynieke.coupons.util.InventoryCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;

public class CouponHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack result = event.getCrafting();
        if (result.func_77973_b().getRegistryName() != null && !result.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("coupons") && InventoryCheck.hasCoupon(player, CouponRegistry.CRAFTING_COUPON)) {
            IInventory inventory = event.getInventory();
            ItemStack refundStack = ItemStack.field_190927_a;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack foundStack = inventory.func_70301_a(i);
                if (foundStack.func_190926_b() || foundStack.func_77984_f() || foundStack.hasContainerItem() || FluidUtil.getFluidHandler((ItemStack)foundStack).isPresent() || CouponHandler.hasEnergy(foundStack) || foundStack.func_77953_t() != Rarity.COMMON) continue;
                refundStack = foundStack.func_77946_l();
                break;
            }
            if (!refundStack.func_190926_b() && player.func_191521_c(refundStack)) {
                InventoryCheck.shrinkCoupon(player, CouponRegistry.CRAFTING_COUPON);
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)refundStack);
            }
        }
    }

    public static boolean hasEnergy(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.EntityInteract event) {
        List blacklist;
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        CompoundNBT nbt = target.getPersistentData();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == CouponRegistry.LOOT_COUPON.get() && !nbt.func_74764_b("coupons:doubleLoot") && target instanceof LivingEntity && (!(blacklist = (List)CouponConfig.COMMON.entityBlacklist.get()).isEmpty() && !blacklist.contains(target.func_200600_R().getRegistryName().toString()) || ((Boolean)CouponConfig.COMMON.doubleBossLoot.get()).booleanValue() && !target.func_184222_aU())) {
            nbt.func_74757_a("coupons:doubleLoot", true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void livingDropsEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        CompoundNBT nbt = entity.getPersistentData();
        if (nbt.func_74764_b("coupons:doubleLoot") && nbt.func_74767_n("coupons:doubleLoot")) {
            Collection drops = event.getDrops();
            ArrayList<ItemEntity> extra = new ArrayList<ItemEntity>();
            for (ItemEntity drop : drops) {
                extra.add(new ItemEntity(drop.field_70170_p, drop.func_226277_ct_(), drop.func_226278_cu_(), drop.func_226281_cx_(), drop.func_92059_d()));
            }
            drops.addAll(extra);
        }
    }

    @SubscribeEvent
    public void onContainer(PlayerContainerEvent.Open event) {
        PlayerEntity player = event.getPlayer();
        if (event.getContainer() instanceof MerchantContainer && InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON)) {
            MerchantContainer container = (MerchantContainer)event.getContainer();
            if (!(container.field_75178_e instanceof WanderingTraderEntity)) {
                int offerSlot = player.func_70681_au().nextInt(container.func_217051_h().size());
                MerchantOffer randomOffer = (MerchantOffer)container.func_217051_h().get(offerSlot);
                int uses = randomOffer.func_222213_g();
                if (randomOffer.func_222218_a().func_190916_E() > 1) {
                    CompoundNBT tag = player.getPersistentData();
                    tag.func_74768_a("coupons:offerSlot", offerSlot);
                    tag.func_74768_a("coupons:offerUses", uses);
                    tag.func_74768_a("coupons:offerSpecialPrice", randomOffer.func_222212_l());
                    randomOffer.func_222207_a(-64);
                }
            }
        }
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close event) {
        PlayerEntity player = event.getPlayer();
        if (event.getContainer() instanceof MerchantContainer && InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON)) {
            MerchantContainer container = (MerchantContainer)event.getContainer();
            CompoundNBT tag = player.getPersistentData();
            if (tag.func_74764_b("coupons:offerSlot") && tag.func_74764_b("coupons:offerUses") && tag.func_74764_b("coupons:offerSpecialPrice")) {
                int offerSlot = tag.func_74762_e("coupons:offerSlot");
                int previousUses = tag.func_74762_e("coupons:offerUses");
                int specialPrice = tag.func_74762_e("coupons:offerSpecialPrice");
                tag.func_82580_o("coupons:offerSlot");
                tag.func_82580_o("coupons:offerUses");
                tag.func_82580_o("coupons:offerSpecialPrice");
                MerchantOffer randomOffer = (MerchantOffer)container.func_217051_h().get(offerSlot);
                if (previousUses != -1 && randomOffer.func_222213_g() != previousUses) {
                    randomOffer.func_222209_b(specialPrice);
                    InventoryCheck.shrinkCoupon(player, CouponRegistry.TRADING_COUPON);
                }
            }
        }
    }
}

