/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.coupons.handler;

import com.shynieke.coupons.CouponRegistry;
import com.shynieke.coupons.config.CouponConfig;
import com.shynieke.coupons.util.InventoryCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;

public class CouponHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getPlayer();
        ItemStack result = event.getCrafting();
        if (result.m_41720_().getRegistryName() != null && !result.m_41720_().getRegistryName().m_135827_().equalsIgnoreCase("coupons") && InventoryCheck.hasCoupon(player, CouponRegistry.CRAFTING_COUPON)) {
            Container inventory = event.getInventory();
            ItemStack refundStack = ItemStack.f_41583_;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack foundStack = inventory.m_8020_(i);
                if (foundStack.m_41619_() || foundStack.m_41763_() || foundStack.hasContainerItem() || FluidUtil.getFluidHandler((ItemStack)foundStack).isPresent() || CouponHandler.hasEnergy(foundStack) || foundStack.m_41791_() != Rarity.COMMON) continue;
                refundStack = foundStack.m_41777_();
                break;
            }
            if (!refundStack.m_41619_() && player.m_36356_(refundStack)) {
                InventoryCheck.shrinkCoupon(player, CouponRegistry.CRAFTING_COUPON);
                Containers.m_18992_((Level)player.f_19853_, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)refundStack);
            }
        }
    }

    public static boolean hasEnergy(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.EntityInteract event) {
        List blacklist;
        Player player = event.getPlayer();
        Entity target = event.getTarget();
        CompoundTag nbt = target.getPersistentData();
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == CouponRegistry.LOOT_COUPON.get() && !nbt.m_128441_("coupons:doubleLoot") && target instanceof LivingEntity && (!(blacklist = (List)CouponConfig.COMMON.entityBlacklist.get()).isEmpty() && target.m_6095_().getRegistryName() != null && !blacklist.contains(target.m_6095_().getRegistryName().toString()) || ((Boolean)CouponConfig.COMMON.doubleBossLoot.get()).booleanValue() && !target.m_6072_())) {
            nbt.m_128379_("coupons:doubleLoot", true);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
    }

    @SubscribeEvent
    public void livingDropsEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        CompoundTag nbt = entity.getPersistentData();
        if (nbt.m_128441_("coupons:doubleLoot") && nbt.m_128471_("coupons:doubleLoot")) {
            Collection drops = event.getDrops();
            ArrayList<ItemEntity> extra = new ArrayList<ItemEntity>();
            for (ItemEntity drop : drops) {
                extra.add(new ItemEntity(drop.f_19853_, drop.m_20185_(), drop.m_20186_(), drop.m_20189_(), drop.m_32055_()));
            }
            drops.addAll(extra);
        }
    }

    @SubscribeEvent
    public void onContainer(PlayerContainerEvent.Open event) {
        Player player = event.getPlayer();
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof MerchantMenu) {
            MerchantMenu container = (MerchantMenu)abstractContainerMenu;
            if (InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON) && !(container.f_40027_ instanceof WanderingTrader)) {
                int offerSlot = player.m_21187_().nextInt(container.m_40075_().size());
                MerchantOffer randomOffer = (MerchantOffer)container.m_40075_().get(offerSlot);
                int uses = randomOffer.m_45371_();
                if (randomOffer.m_45352_().m_41613_() > 1) {
                    CompoundTag tag = player.getPersistentData();
                    tag.m_128405_("coupons:offerSlot", offerSlot);
                    tag.m_128405_("coupons:offerUses", uses);
                    tag.m_128405_("coupons:offerSpecialPrice", randomOffer.m_45377_());
                    randomOffer.m_45353_(-64);
                }
            }
        }
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close event) {
        Player player = event.getPlayer();
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof MerchantMenu) {
            CompoundTag tag;
            MerchantMenu container = (MerchantMenu)abstractContainerMenu;
            if (InventoryCheck.hasCoupon(player, CouponRegistry.TRADING_COUPON) && (tag = player.getPersistentData()).m_128441_("coupons:offerSlot") && tag.m_128441_("coupons:offerUses") && tag.m_128441_("coupons:offerSpecialPrice")) {
                int offerSlot = tag.m_128451_("coupons:offerSlot");
                int previousUses = tag.m_128451_("coupons:offerUses");
                int specialPrice = tag.m_128451_("coupons:offerSpecialPrice");
                tag.m_128473_("coupons:offerSlot");
                tag.m_128473_("coupons:offerUses");
                tag.m_128473_("coupons:offerSpecialPrice");
                MerchantOffer randomOffer = (MerchantOffer)container.m_40075_().get(offerSlot);
                if (previousUses != -1 && randomOffer.m_45371_() != previousUses) {
                    randomOffer.m_45359_(specialPrice);
                    InventoryCheck.shrinkCoupon(player, CouponRegistry.TRADING_COUPON);
                }
            }
        }
    }
}

