/*
 * Decompiled with CFR 0.152.
 */
package crimsonfluff.crimsoncompass;

import crimsonfluff.crimsoncompass.ConfigBuilder;
import crimsonfluff.crimsoncompass.DeathCapability;
import crimsonfluff.crimsoncompass.PlayerProperties;
import crimsonfluff.crimsoncompass.PropertiesDispatcher;
import crimsonfluff.crimsoncompass.init.itemsInit;
import crimsonfluff.crimsoncompass.init.soundsInit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="crimsoncompass")
public class CrimsonCompass {
    public static final String MOD_ID = "crimsoncompass";
    public static final ConfigBuilder CONFIGURATION = new ConfigBuilder();
    public static final CreativeModeTab TAB = new CreativeModeTab("crimsoncompass"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)itemsInit.COMPASS_MONUMENT.get());
        }
    };

    public CrimsonCompass() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CrimsonCompass.CONFIGURATION.COMMON);
        soundsInit.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        itemsInit.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(DeathCapability.class);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity().f_19853_ instanceof ServerLevel && (entity = event.getEntity()) instanceof Player) {
            Player playerIn = (Player)entity;
            playerIn.getCapability(PlayerProperties.PLAYER_DEATH, null).ifPresent(cap -> cap.deathPosWrite(playerIn.m_142538_()));
        }
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerProperties.PLAYER_DEATH).isPresent()) {
            event.addCapability(new ResourceLocation(MOD_ID, ""), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            LazyOptional capability = event.getOriginal().getCapability(PlayerProperties.PLAYER_DEATH);
            capability.ifPresent(oldPlayer -> event.getPlayer().getCapability(PlayerProperties.PLAYER_DEATH).ifPresent(newPlayer -> {
                newPlayer.copyFrom((DeathCapability)oldPlayer);
                if (((Boolean)CrimsonCompass.CONFIGURATION.compassUponDeath.get()).booleanValue()) {
                    ItemStack COMPASS = new ItemStack((ItemLike)itemsInit.COMPASS_DEATH.get());
                    COMPASS.m_41784_().m_128385_("pos", oldPlayer.deathPosRead());
                    event.getPlayer().m_36356_(COMPASS);
                }
            }));
        }
    }

    public static float getDistance(double x1, double z1, double x2, double z2) {
        double i = x2 - x1;
        double j = z2 - z1;
        return Mth.m_14116_((float)((float)(i * i + j * j)));
    }
}

